/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cluster.v0;

import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.exception.OClusterPositionMapException;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPositionMap;
import com.orientechnologies.orient.core.storage.cluster.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.io.IOException;
import java.util.Arrays;

public class OClusterPositionMapV0
extends OClusterPositionMap {
    private long fileId;

    OClusterPositionMapV0(OAbstractPaginatedStorage storage, String name, String lockName) {
        super(storage, name, ".cpm", lockName);
    }

    public void open(OAtomicOperation atomicOperation) throws IOException {
        this.fileId = this.openFile(atomicOperation, this.getFullName());
    }

    public void create(OAtomicOperation atomicOperation) throws IOException {
        this.fileId = this.addFile(atomicOperation, this.getFullName());
    }

    public void flush() {
        this.writeCache.flush(this.fileId);
    }

    public void close(boolean flush) throws IOException {
        this.readCache.closeFile(this.fileId, flush, this.writeCache);
    }

    public void delete(OAtomicOperation atomicOperation) throws IOException {
        this.deleteFile(atomicOperation, this.fileId);
    }

    void rename(String newName) throws IOException {
        this.writeCache.renameFile(this.fileId, newName + this.getExtension());
        this.setName(newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(long pageIndex, int recordPosition, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry cacheEntry;
        long lastPage = this.getFilledUpTo(atomicOperation, this.fileId) - 1L;
        boolean clear = false;
        if (lastPage < 0L) {
            cacheEntry = this.addPage(atomicOperation, this.fileId);
            clear = true;
        } else {
            cacheEntry = OClusterPositionMapV0.loadPageForWrite(atomicOperation, this.fileId, lastPage, false, true);
        }
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
            if (clear) {
                bucket.init();
            }
            if (bucket.isFull()) {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
                cacheEntry = this.addPage(atomicOperation, this.fileId);
                bucket = new OClusterPositionMapBucket(cacheEntry);
                bucket.init();
            }
            long index = bucket.add(pageIndex, recordPosition);
            long l = index + (long)(cacheEntry.getPageIndex() * OClusterPositionMapBucket.MAX_ENTRIES);
            return l;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocate(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry cacheEntry;
        boolean clear = false;
        long lastPage = this.getFilledUpTo(atomicOperation, this.fileId) - 1L;
        if (lastPage < 0L) {
            cacheEntry = this.addPage(atomicOperation, this.fileId);
            clear = true;
        } else {
            cacheEntry = OClusterPositionMapV0.loadPageForWrite(atomicOperation, this.fileId, lastPage, false, true);
        }
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
            if (clear) {
                bucket.init();
            }
            if (bucket.isFull()) {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
                cacheEntry = this.addPage(atomicOperation, this.fileId);
                bucket = new OClusterPositionMapBucket(cacheEntry);
                if (clear) {
                    bucket.init();
                }
            }
            long index = bucket.allocate();
            long l = index + (long)(cacheEntry.getPageIndex() * OClusterPositionMapBucket.MAX_ENTRIES);
            return l;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long clusterPosition, OClusterPositionMapBucket.PositionEntry entry, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        if (pageIndex >= this.getFilledUpTo(atomicOperation, this.fileId)) {
            throw new OClusterPositionMapException("Passed in cluster position " + clusterPosition + " is outside of range of cluster-position map", this);
        }
        OCacheEntry cacheEntry = OClusterPositionMapV0.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
            bucket.set(index, entry);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPositionMapBucket.PositionEntry get(long clusterPosition, int pageCount, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        if (pageIndex >= this.getFilledUpTo(atomicOperation, this.fileId)) {
            return null;
        }
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, pageCount);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
            OClusterPositionMapBucket.PositionEntry positionEntry = bucket.get(index);
            return positionEntry;
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        OCacheEntry cacheEntry = OClusterPositionMapV0.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
            bucket.remove(index);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
    }

    long[] higherPositions(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        if (clusterPosition == Long.MAX_VALUE) {
            return OCommonConst.EMPTY_LONG_ARRAY;
        }
        return this.ceilingPositions(clusterPosition + 1L, atomicOperation);
    }

    OClusterPositionEntry[] higherPositionsEntries(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        long realPosition = clusterPosition + 1L;
        if (clusterPosition == Long.MAX_VALUE) {
            return new OClusterPositionEntry[0];
        }
        if (realPosition < 0L) {
            realPosition = 0L;
        }
        long pageIndex = realPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES;
        int index = (int)(realPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        long filledUpTo = this.getFilledUpTo(atomicOperation, this.fileId);
        if (pageIndex >= filledUpTo) {
            return new OClusterPositionEntry[0];
        }
        OClusterPositionEntry[] result = null;
        do {
            OCacheEntry cacheEntry;
            OClusterPositionMapBucket bucket;
            int resultSize;
            if ((resultSize = (bucket = new OClusterPositionMapBucket(cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1))).getSize() - index) <= 0) {
                this.releasePageFromRead(atomicOperation, cacheEntry);
                ++pageIndex;
                index = 0;
                continue;
            }
            int entriesCount = 0;
            long startIndex = cacheEntry.getPageIndex() * OClusterPositionMapBucket.MAX_ENTRIES + index;
            result = new OClusterPositionEntry[resultSize];
            for (int i = 0; i < resultSize; ++i) {
                if (!bucket.exists(i + index)) continue;
                OClusterPositionMapBucket.PositionEntry val = bucket.get(i + index);
                assert (val != null);
                result[entriesCount] = new OClusterPositionEntry(startIndex + (long)i, val.getPageIndex(), val.getRecordPosition());
                ++entriesCount;
            }
            if (entriesCount == 0) {
                result = null;
                ++pageIndex;
                index = 0;
            } else {
                result = Arrays.copyOf(result, entriesCount);
            }
            this.releasePageFromRead(atomicOperation, cacheEntry);
        } while (result == null && pageIndex < filledUpTo);
        if (result == null) {
            result = new OClusterPositionEntry[]{};
        }
        return result;
    }

    long[] ceilingPositions(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        if (clusterPosition < 0L) {
            clusterPosition = 0L;
        }
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        long filledUpTo = this.getFilledUpTo(atomicOperation, this.fileId);
        if (pageIndex >= filledUpTo) {
            return OCommonConst.EMPTY_LONG_ARRAY;
        }
        long[] result = null;
        do {
            OCacheEntry cacheEntry;
            OClusterPositionMapBucket bucket;
            int resultSize;
            if ((resultSize = (bucket = new OClusterPositionMapBucket(cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1))).getSize() - index) <= 0) {
                this.releasePageFromRead(atomicOperation, cacheEntry);
                ++pageIndex;
                index = 0;
                continue;
            }
            int entriesCount = 0;
            long startIndex = cacheEntry.getPageIndex() * OClusterPositionMapBucket.MAX_ENTRIES + index;
            result = new long[resultSize];
            for (int i = 0; i < resultSize; ++i) {
                if (!bucket.exists(i + index)) continue;
                result[entriesCount] = startIndex + (long)i;
                ++entriesCount;
            }
            if (entriesCount == 0) {
                result = null;
                ++pageIndex;
                index = 0;
            } else {
                result = Arrays.copyOf(result, entriesCount);
            }
            this.releasePageFromRead(atomicOperation, cacheEntry);
        } while (result == null && pageIndex < filledUpTo);
        if (result == null) {
            result = OCommonConst.EMPTY_LONG_ARRAY;
        }
        return result;
    }

    long[] lowerPositions(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        if (clusterPosition == 0L) {
            return OCommonConst.EMPTY_LONG_ARRAY;
        }
        return this.floorPositions(clusterPosition - 1L, atomicOperation);
    }

    long[] floorPositions(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        long[] result;
        if (clusterPosition < 0L) {
            return OCommonConst.EMPTY_LONG_ARRAY;
        }
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        long filledUpTo = this.getFilledUpTo(atomicOperation, this.fileId);
        if (pageIndex >= filledUpTo) {
            pageIndex = filledUpTo - 1L;
            index = Integer.MIN_VALUE;
        }
        if (pageIndex < 0L) {
            return OCommonConst.EMPTY_LONG_ARRAY;
        }
        do {
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1);
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
            if (index == Integer.MIN_VALUE) {
                index = bucket.getSize() - 1;
            }
            int resultSize = index + 1;
            int entriesCount = 0;
            long startPosition = cacheEntry.getPageIndex() * OClusterPositionMapBucket.MAX_ENTRIES;
            result = new long[resultSize];
            for (int i = 0; i < resultSize; ++i) {
                if (!bucket.exists(i)) continue;
                result[entriesCount] = startPosition + (long)i;
                ++entriesCount;
            }
            if (entriesCount == 0) {
                result = null;
                --pageIndex;
                index = Integer.MIN_VALUE;
            } else {
                result = Arrays.copyOf(result, entriesCount);
            }
            this.releasePageFromRead(atomicOperation, cacheEntry);
        } while (result == null && pageIndex >= 0L);
        if (result == null) {
            result = OCommonConst.EMPTY_LONG_ARRAY;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getFirstPosition(OAtomicOperation atomicOperation) throws IOException {
        long filledUpTo = this.getFilledUpTo(atomicOperation, this.fileId);
        for (long pageIndex = 0L; pageIndex < filledUpTo; ++pageIndex) {
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1);
            try {
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
                int bucketSize = bucket.getSize();
                for (int index = 0; index < bucketSize; ++index) {
                    if (!bucket.exists(index)) continue;
                    long l = pageIndex * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)index;
                    return l;
                }
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, cacheEntry);
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getStatus(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        if (pageIndex >= this.getFilledUpTo(atomicOperation, this.fileId)) {
            return 0;
        }
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
            byte by = bucket.getStatus(index);
            return by;
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastPosition(OAtomicOperation atomicOperation) throws IOException {
        long filledUpTo = this.getFilledUpTo(atomicOperation, this.fileId);
        for (long pageIndex = filledUpTo - 1L; pageIndex >= 0L; --pageIndex) {
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1);
            try {
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
                int bucketSize = bucket.getSize();
                for (int index = bucketSize - 1; index >= 0; --index) {
                    if (!bucket.exists(index)) continue;
                    long l = pageIndex * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)index;
                    return l;
                }
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, cacheEntry);
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextPosition(OAtomicOperation atomicOperation) throws IOException {
        long filledUpTo = this.getFilledUpTo(atomicOperation, this.fileId);
        long pageIndex = filledUpTo - 1L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
            int bucketSize = bucket.getSize();
            long l = pageIndex * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)bucketSize;
            return l;
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    public long getFileId() {
        return this.fileId;
    }

    public static class OClusterPositionEntry {
        private final long position;
        private final long page;
        private final int offset;

        OClusterPositionEntry(long position, long page, int offset) {
            this.position = position;
            this.page = page;
            this.offset = offset;
        }

        public long getPosition() {
            return this.position;
        }

        public long getPage() {
            return this.page;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

