/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cluster.v2;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v2.paginatedclusterstate.PaginatedClusterStateV2SetFileSizePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v2.paginatedclusterstate.PaginatedClusterStateV2SetFreeListPagePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v2.paginatedclusterstate.PaginatedClusterStateV2SetRecordsSizePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v2.paginatedclusterstate.PaginatedClusterStateV2SetSizePO;

public final class OPaginatedClusterStateV2
extends ODurablePage {
    private static final int RECORDS_SIZE_OFFSET = 28;
    private static final int SIZE_OFFSET = 32;
    private static final int FILE_SIZE_OFFSET = 36;
    private static final int FREE_LIST_OFFSET = 40;

    public OPaginatedClusterStateV2(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void setSize(int size) {
        int oldSize = this.getIntValue(32);
        this.setIntValue(32, size);
        this.addPageOperation(new PaginatedClusterStateV2SetSizePO(oldSize, size));
    }

    public int getSize() {
        return this.getIntValue(32);
    }

    public void setRecordsSize(int recordsSize) {
        int oldRecordsSize = this.getIntValue(28);
        this.setIntValue(28, recordsSize);
        this.addPageOperation(new PaginatedClusterStateV2SetRecordsSizePO(oldRecordsSize, recordsSize));
    }

    public int getRecordsSize() {
        return this.getIntValue(28);
    }

    public void setFileSize(int size) {
        int oldFileSize = this.getIntValue(36);
        this.setIntValue(36, size);
        this.addPageOperation(new PaginatedClusterStateV2SetFileSizePO(oldFileSize, size));
    }

    public int getFileSize() {
        return this.getIntValue(36);
    }

    public void setFreeListPage(int index, int pageIndex) {
        int pageOffset = 40 + index * 4;
        int oldPageIndex = this.getIntValue(pageOffset);
        this.setIntValue(pageOffset, pageIndex);
        this.addPageOperation(new PaginatedClusterStateV2SetFreeListPagePO(index, oldPageIndex, pageIndex));
    }

    public int getFreeListPage(int index) {
        return this.getIntValue(40 + index * 4);
    }
}

