/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfigurationImpl;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.nio.charset.Charset;

public class OStorageMemoryConfiguration
extends OStorageConfigurationImpl {
    private static final long serialVersionUID = 7001342008735208586L;
    private byte[] serializedContent;

    public OStorageMemoryConfiguration(OAbstractPaginatedStorage iStorage) {
        super(iStorage, Charset.forName("UTF-8"));
    }

    @Override
    public OStorageConfigurationImpl load(OContextConfiguration configuration) throws OSerializationException {
        this.lock.acquireWriteLock();
        try {
            this.initConfiguration(configuration);
            try {
                this.fromStream(this.serializedContent, 0, this.serializedContent.length, this.streamCharset);
            }
            catch (Exception e) {
                throw OException.wrapException(new OSerializationException("Cannot load database configuration. The database seems corrupted"), e);
            }
            OStorageMemoryConfiguration oStorageMemoryConfiguration = this;
            return oStorageMemoryConfiguration;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public void update() throws OSerializationException {
        this.lock.acquireWriteLock();
        try {
            try {
                this.serializedContent = this.toStream(this.streamCharset);
            }
            catch (Exception e) {
                throw OException.wrapException(new OSerializationException("Error on update storage configuration"), e);
            }
            if (this.updateListener != null) {
                this.updateListener.onUpdate(this);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }
}

