/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OStringSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitBodyRecord;
import java.nio.ByteBuffer;

public class OFileCreatedWALRecord
extends OOperationUnitBodyRecord {
    private String fileName;
    private long fileId;

    public OFileCreatedWALRecord() {
    }

    public OFileCreatedWALRecord(long operationUnitId, String fileName, long fileId) {
        super(operationUnitId);
        this.fileName = fileName;
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileId() {
        return this.fileId;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        OStringSerializer.INSTANCE.serializeInByteBufferObject(this.fileName, buffer, new Object[0]);
        buffer.putLong(this.fileId);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        this.fileName = OStringSerializer.INSTANCE.deserializeFromByteBufferObject(buffer);
        this.fileId = buffer.getLong();
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + OStringSerializer.INSTANCE.getObjectSize(this.fileName, new Object[0]) + 8;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public int getId() {
        return 10;
    }
}

