/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.types.OModifiableLong;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

public class OOperationUnitId {
    private static final AtomicLong sharedId = new AtomicLong();
    private static volatile ThreadLocal<OModifiableLong> localId = new ThreadLocal();
    private static volatile ThreadLocal<Long> sharedIdCopy = new ThreadLocal();
    public static final int SERIALIZED_SIZE = 16;
    private long lId;
    private long sId;

    public OOperationUnitId(long lId, long sId) {
        this.lId = lId;
        this.sId = sId;
    }

    public static OOperationUnitId generateId() {
        OOperationUnitId operationUnitId = new OOperationUnitId();
        OModifiableLong lId = localId.get();
        if (lId == null) {
            lId = new OModifiableLong();
            localId.set(lId);
        }
        lId.increment();
        Long sId = sharedIdCopy.get();
        if (sId == null) {
            sId = sharedId.incrementAndGet();
            sharedIdCopy.set(sId);
        }
        operationUnitId.lId = lId.getValue();
        operationUnitId.sId = sId;
        return operationUnitId;
    }

    public OOperationUnitId() {
    }

    public int toStream(byte[] content, int offset) {
        OLongSerializer.INSTANCE.serializeNative(this.sId, content, offset, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(this.lId, content, offset += 8, new Object[0]);
        return offset += 8;
    }

    public void toStream(ByteBuffer buffer) {
        buffer.putLong(this.sId);
        buffer.putLong(this.lId);
    }

    public int fromStream(byte[] content, int offset) {
        this.sId = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        this.lId = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        return offset += 8;
    }

    public void fromStream(ByteBuffer buffer) {
        this.sId = buffer.getLong();
        this.lId = buffer.getLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OOperationUnitId)) {
            return false;
        }
        OOperationUnitId that = (OOperationUnitId)o;
        if (this.lId != that.lId) {
            return false;
        }
        return this.sId == that.sId;
    }

    public int hashCode() {
        int result = (int)(this.lId ^ this.lId >>> 32);
        result = 31 * result + (int)(this.sId ^ this.sId >>> 32);
        return result;
    }

    public String toString() {
        return "OOperationUnitId{lId=" + this.lId + ", sId=" + this.sId + '}';
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (localId == null) {
                    localId = new ThreadLocal();
                }
                if (sharedIdCopy == null) {
                    sharedIdCopy = new ThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                localId = null;
                sharedIdCopy = null;
            }
        });
    }
}

