/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.bucket;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2Bucket;
import java.nio.ByteBuffer;

public final class CellBTreeMultiValueV2BucketRemoveLeafEntryPO
extends PageOperationRecord {
    private int index;
    private ORID value;

    public CellBTreeMultiValueV2BucketRemoveLeafEntryPO() {
    }

    public CellBTreeMultiValueV2BucketRemoveLeafEntryPO(int index, ORID value) {
        this.index = index;
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public ORID getValue() {
        return this.value;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        int result = bucket.removeLeafEntry(this.index, this.value);
        if (result < 0) {
            throw new IllegalStateException("Can not redo remove leaf entry operation");
        }
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        long result = bucket.appendNewLeafEntry(this.index, this.value);
        if (result != -1L) {
            throw new IllegalStateException("Can not undo remove leaf entry operation");
        }
    }

    @Override
    public int getId() {
        return 128;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 4 + 8 + 2;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.putShort((short)this.value.getClusterId());
        buffer.putLong(this.value.getClusterPosition());
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        short clusterId = buffer.getShort();
        long clusterPosition = buffer.getLong();
        this.value = new ORecordId(clusterId, clusterPosition);
    }
}

