/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.nullbucket;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2NullBucket;
import java.nio.ByteBuffer;

public final class CellBTreeMultiValueV2NullBucketAddValuePO
extends PageOperationRecord {
    private ORID rid;

    public CellBTreeMultiValueV2NullBucketAddValuePO() {
    }

    public CellBTreeMultiValueV2NullBucketAddValuePO(ORID rid) {
        this.rid = rid;
    }

    public ORID getRid() {
        return this.rid;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2NullBucket bucket = new CellBTreeMultiValueV2NullBucket(cacheEntry);
        long result = bucket.addValue(this.rid);
        if (result != -1L) {
            throw new IllegalStateException("Can not redo 'add value' operation");
        }
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2NullBucket bucket = new CellBTreeMultiValueV2NullBucket(cacheEntry);
        int result = bucket.removeValue(this.rid);
        if (result != 1) {
            throw new IllegalStateException("Can not undo 'add value' operation");
        }
    }

    @Override
    public int getId() {
        return 140;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 2 + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putShort((short)this.rid.getClusterId());
        buffer.putLong(this.rid.getClusterPosition());
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        short clusterId = buffer.getShort();
        long clusterPosition = buffer.getLong();
        this.rid = new ORecordId(clusterId, clusterPosition);
    }
}

