/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v1.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v1.CellBTreeBucketSingleValueV1;
import java.nio.ByteBuffer;

public final class CellBTreeBucketSingleValueV1RemoveNonLeafEntryPO
extends PageOperationRecord {
    private int index;
    private int prevChild;
    private byte[] key;
    private int leftChild;
    private int rightChild;

    public CellBTreeBucketSingleValueV1RemoveNonLeafEntryPO() {
    }

    public CellBTreeBucketSingleValueV1RemoveNonLeafEntryPO(int index, int prevChild, byte[] key, int leftChild, int rightChild) {
        this.index = index;
        this.prevChild = prevChild;
        this.key = key;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
    }

    public int getIndex() {
        return this.index;
    }

    public int getPrevChild() {
        return this.prevChild;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getLeftChild() {
        return this.leftChild;
    }

    public int getRightChild() {
        return this.rightChild;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeBucketSingleValueV1 bucket = new CellBTreeBucketSingleValueV1(cacheEntry);
        bucket.removeNonLeafEntry(this.index, this.key, this.prevChild);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeBucketSingleValueV1 bucket = new CellBTreeBucketSingleValueV1(cacheEntry);
        bucket.addNonLeafEntry(this.index, this.leftChild, this.rightChild, this.key, true);
    }

    @Override
    public int getId() {
        return 64;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 20 + this.key.length;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.putInt(this.prevChild);
        buffer.putInt(this.key.length);
        buffer.put(this.key);
        buffer.putInt(this.leftChild);
        buffer.putInt(this.rightChild);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        this.prevChild = buffer.getInt();
        int keyLen = buffer.getInt();
        this.key = new byte[keyLen];
        buffer.get(this.key);
        this.leftChild = buffer.getInt();
        this.rightChild = buffer.getInt();
    }
}

