/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3.CellBTreeSingleValueBucketV3;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class CellBTreeBucketSingleValueV3ShrinkPO
extends PageOperationRecord {
    private int newSize;
    private List<byte[]> removedRecords;
    private OBinarySerializer keySerializer;

    public CellBTreeBucketSingleValueV3ShrinkPO() {
    }

    public CellBTreeBucketSingleValueV3ShrinkPO(int newSize, List<byte[]> removedRecords, OBinarySerializer keySerializer) {
        this.newSize = newSize;
        this.removedRecords = removedRecords;
        this.keySerializer = keySerializer;
    }

    public int getNewSize() {
        return this.newSize;
    }

    public List<byte[]> getRemovedRecords() {
        return this.removedRecords;
    }

    public OBinarySerializer getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeSingleValueBucketV3 bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
        bucket.shrink(this.newSize, this.keySerializer);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeSingleValueBucketV3 bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
        bucket.addAll(this.removedRecords, this.keySerializer);
    }

    @Override
    public int getId() {
        return 82;
    }

    @Override
    public int serializedSize() {
        int serializedSize = 9 + this.removedRecords.size() * 4;
        for (byte[] record : this.removedRecords) {
            serializedSize += record.length;
        }
        return super.serializedSize() + serializedSize;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.newSize);
        buffer.putInt(this.removedRecords.size());
        for (byte[] record : this.removedRecords) {
            buffer.putInt(record.length);
            buffer.put(record);
        }
        buffer.put(this.keySerializer.getId());
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.newSize = buffer.getInt();
        int records = buffer.getInt();
        this.removedRecords = new ArrayList<byte[]>();
        for (int i = 0; i < records; ++i) {
            int recordLen = buffer.getInt();
            byte[] record = new byte[recordLen];
            buffer.get(record);
            this.removedRecords.add(record);
        }
        this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
    }
}

