/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;
import java.util.Collections;

public final class ClusterPageAppendRecordPO
extends PageOperationRecord {
    private int recordVersion;
    private byte[] record;
    private int requestedPosition;
    private int recordPosition;
    private boolean allocatedFromFreeList;

    public ClusterPageAppendRecordPO() {
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    public byte[] getRecord() {
        return this.record;
    }

    public int getRequestedPosition() {
        return this.requestedPosition;
    }

    public int getRecordPosition() {
        return this.recordPosition;
    }

    public boolean isAllocatedFromFreeList() {
        return this.allocatedFromFreeList;
    }

    public ClusterPageAppendRecordPO(int recordVersion, byte[] record, int requestedPosition, int recordPosition, boolean allocatedFromFreeList) {
        this.recordVersion = recordVersion;
        this.record = record;
        this.requestedPosition = requestedPosition;
        this.recordPosition = recordPosition;
        this.allocatedFromFreeList = allocatedFromFreeList;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OClusterPage clusterPage = new OClusterPage(cacheEntry);
        int allocatedPosition = this.requestedPosition < 0 ? clusterPage.appendRecord(this.recordVersion, this.record, this.recordPosition, Collections.emptySet()) : clusterPage.appendRecord(this.recordVersion, this.record, this.requestedPosition, Collections.emptySet());
        if (allocatedPosition < 0) {
            throw new IllegalStateException("Can not redo operation of record creation");
        }
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OClusterPage clusterPage = new OClusterPage(cacheEntry);
        byte[] deletedRecord = clusterPage.deleteRecord(this.recordPosition, this.allocatedFromFreeList);
        if (deletedRecord == null) {
            throw new IllegalStateException("Can not undo operation of record creation");
        }
    }

    @Override
    public int getId() {
        return 43;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16 + this.record.length + 1;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.put(this.allocatedFromFreeList ? (byte)1 : 0);
        buffer.putInt(this.recordVersion);
        buffer.putInt(this.requestedPosition);
        buffer.putInt(this.recordPosition);
        buffer.putInt(this.record.length);
        buffer.put(this.record);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.allocatedFromFreeList = buffer.get() > 0;
        this.recordVersion = buffer.getInt();
        this.requestedPosition = buffer.getInt();
        this.recordPosition = buffer.getInt();
        int recordLen = buffer.getInt();
        this.record = new byte[recordLen];
        buffer.get(this.record);
    }
}

