/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;
import java.util.Collections;

public final class ClusterPageDeleteRecordPO
extends PageOperationRecord {
    private int recordPosition;
    private int recordVersion;
    private byte[] record;
    private boolean preserveFreeListPointer;

    public ClusterPageDeleteRecordPO() {
    }

    public ClusterPageDeleteRecordPO(int recordPosition, int recordVersion, byte[] record, boolean preserveFreeListPointer) {
        this.recordPosition = recordPosition;
        this.recordVersion = recordVersion;
        this.record = record;
        this.preserveFreeListPointer = preserveFreeListPointer;
    }

    public int getRecordPosition() {
        return this.recordPosition;
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    public byte[] getRecord() {
        return this.record;
    }

    public boolean isPreserveFreeListPointer() {
        return this.preserveFreeListPointer;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OClusterPage clusterPage = new OClusterPage(cacheEntry);
        byte[] deletedRecord = clusterPage.deleteRecord(this.recordPosition, this.preserveFreeListPointer);
        if (deletedRecord == null) {
            throw new IllegalStateException("Can not redo operation of record deletion");
        }
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OClusterPage clusterPage = new OClusterPage(cacheEntry);
        int allocatedPosition = clusterPage.appendRecord(this.recordVersion, this.record, this.recordPosition, Collections.emptySet());
        if (allocatedPosition < 0) {
            throw new IllegalStateException("Can not undo operation of record creation.");
        }
    }

    @Override
    public int getId() {
        return 45;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 1 + 12 + this.record.length;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.put(this.preserveFreeListPointer ? (byte)1 : 0);
        buffer.putInt(this.recordPosition);
        buffer.putInt(this.recordVersion);
        buffer.putInt(this.record.length);
        buffer.put(this.record);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.preserveFreeListPointer = buffer.get() != 0;
        this.recordPosition = buffer.getInt();
        this.recordVersion = buffer.getInt();
        int recLen = buffer.getInt();
        this.record = new byte[recLen];
        buffer.get(this.record);
    }
}

