/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class ClusterPageSetPrevPagePO
extends PageOperationRecord {
    private int oldPrevPage;
    private int prevPage;

    public ClusterPageSetPrevPagePO() {
    }

    public ClusterPageSetPrevPagePO(int oldPrevPage, int prevPage) {
        this.oldPrevPage = oldPrevPage;
        this.prevPage = prevPage;
    }

    public int getOldPrevPage() {
        return this.oldPrevPage;
    }

    public int getPrevPage() {
        return this.prevPage;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OClusterPage page = new OClusterPage(cacheEntry);
        page.setPrevPage(this.prevPage);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OClusterPage page = new OClusterPage(cacheEntry);
        page.setPrevPage(this.oldPrevPage);
    }

    @Override
    public int getId() {
        return 47;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.oldPrevPage);
        buffer.putInt(this.prevPage);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.oldPrevPage = buffer.getInt();
        this.prevPage = buffer.getInt();
    }
}

