/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class ClusterPageSetRecordLongValuePO
extends PageOperationRecord {
    private int recordPosition;
    private int offset;
    private long value;
    private long oldValue;

    public ClusterPageSetRecordLongValuePO() {
    }

    public ClusterPageSetRecordLongValuePO(int recordPosition, int offset, long value, long oldValue) {
        this.recordPosition = recordPosition;
        this.offset = offset;
        this.value = value;
        this.oldValue = oldValue;
    }

    public int getRecordPosition() {
        return this.recordPosition;
    }

    public int getOffset() {
        return this.offset;
    }

    public long getValue() {
        return this.value;
    }

    public long getOldValue() {
        return this.oldValue;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OClusterPage clusterPage = new OClusterPage(cacheEntry);
        clusterPage.setRecordLongValue(this.recordPosition, this.offset, this.value);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OClusterPage clusterPage = new OClusterPage(cacheEntry);
        clusterPage.setRecordLongValue(this.recordPosition, this.offset, this.oldValue);
    }

    @Override
    public int getId() {
        return 48;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8 + 16;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.recordPosition);
        buffer.putInt(this.offset);
        buffer.putLong(this.value);
        buffer.putLong(this.oldValue);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.recordPosition = buffer.getInt();
        this.offset = buffer.getInt();
        this.value = buffer.getLong();
        this.oldValue = buffer.getLong();
    }
}

