/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpositionmapbucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class ClusterPositionMapBucketAddPO
extends PageOperationRecord {
    private int recordPageIndex;
    private int recordPosition;
    private byte status;

    public ClusterPositionMapBucketAddPO() {
    }

    public ClusterPositionMapBucketAddPO(int recordPageIndex, int recordPosition, byte status) {
        this.recordPageIndex = recordPageIndex;
        this.recordPosition = recordPosition;
        this.status = status;
    }

    public int getRecordPageIndex() {
        return this.recordPageIndex;
    }

    public int getRecordPosition() {
        return this.recordPosition;
    }

    public byte getStatus() {
        return this.status;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
        bucket.add(this.recordPageIndex, this.recordPosition, this.status);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
        bucket.truncateLastEntry();
    }

    @Override
    public int getId() {
        return 36;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8 + 1;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.put(this.status);
        buffer.putInt(this.recordPageIndex);
        buffer.putInt(this.recordPosition);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.status = buffer.get();
        this.recordPageIndex = buffer.getInt();
        this.recordPosition = buffer.getInt();
    }
}

