/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpositionmapbucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class ClusterPositionMapBucketUpdateStatusPO
extends PageOperationRecord {
    private int index;
    private byte recordOldStatus;
    private byte recordStatus;

    public ClusterPositionMapBucketUpdateStatusPO() {
    }

    public ClusterPositionMapBucketUpdateStatusPO(int index, byte recordOldStatus, byte recordStatus) {
        this.index = index;
        this.recordOldStatus = recordOldStatus;
        this.recordStatus = recordStatus;
    }

    public int getIndex() {
        return this.index;
    }

    public byte getRecordOldStatus() {
        return this.recordOldStatus;
    }

    public byte getRecordStatus() {
        return this.recordStatus;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
        bucket.updateStatus(this.index, this.recordStatus);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
        bucket.updateStatus(this.index, this.recordOldStatus);
    }

    @Override
    public int getId() {
        return 41;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 4 + 2;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.put(this.recordOldStatus);
        buffer.put(this.recordStatus);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        this.recordOldStatus = buffer.get();
        this.recordStatus = buffer.get();
    }
}

