/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v0.paginatedclusterstate;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.v0.OPaginatedClusterStateV0;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class PaginatedClusterStateV0SetFreeListPagePO
extends PageOperationRecord {
    private int index;
    private int oldPageIndex;
    private int newPageIndex;

    public PaginatedClusterStateV0SetFreeListPagePO() {
    }

    public PaginatedClusterStateV0SetFreeListPagePO(int index, int oldPageIndex, int newPageIndex) {
        this.index = index;
        this.oldPageIndex = oldPageIndex;
        this.newPageIndex = newPageIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOldPageIndex() {
        return this.oldPageIndex;
    }

    public int getNewPageIndex() {
        return this.newPageIndex;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV0 paginatedClusterStateV0 = new OPaginatedClusterStateV0(cacheEntry);
        paginatedClusterStateV0.setFreeListPage(this.index, this.newPageIndex);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV0 paginatedClusterStateV0 = new OPaginatedClusterStateV0(cacheEntry);
        paginatedClusterStateV0.setFreeListPage(this.index, this.oldPageIndex);
    }

    @Override
    public int getId() {
        return 51;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 12;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.putInt(this.oldPageIndex);
        buffer.putInt(this.newPageIndex);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        this.oldPageIndex = buffer.getInt();
        this.newPageIndex = buffer.getInt();
    }
}

