/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v1.paginatedclusterstate;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.v1.OPaginatedClusterStateV1;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class PaginatedClusterStateV1SetSizePO
extends PageOperationRecord {
    private int oldSize;
    private int newSize;

    public PaginatedClusterStateV1SetSizePO() {
    }

    public PaginatedClusterStateV1SetSizePO(int oldSize, int newSize) {
        this.oldSize = oldSize;
        this.newSize = newSize;
    }

    public long getOldSize() {
        return this.oldSize;
    }

    public long getNewSize() {
        return this.newSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV1 paginatedClusterStateV1 = new OPaginatedClusterStateV1(cacheEntry);
        paginatedClusterStateV1.setSize(this.newSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV1 paginatedClusterStateV1 = new OPaginatedClusterStateV1(cacheEntry);
        paginatedClusterStateV1.setSize(this.oldSize);
    }

    @Override
    public int getId() {
        return 54;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.oldSize);
        buffer.putInt(this.newSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.oldSize = buffer.getInt();
        this.newSize = buffer.getInt();
    }
}

