/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.HashIndexBucketV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2BucketDeleteEntryPO
extends PageOperationRecord {
    private int index;
    private long hashCode;
    private byte[] key;
    private byte[] value;

    public LocalHashTableV2BucketDeleteEntryPO() {
    }

    public LocalHashTableV2BucketDeleteEntryPO(int index, long hashCode, byte[] key, byte[] value) {
        this.index = index;
        this.hashCode = hashCode;
        this.key = key;
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public long getHashCode() {
        return this.hashCode;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        HashIndexBucketV2 bucket = new HashIndexBucketV2(cacheEntry);
        bucket.deleteEntry(this.index, this.hashCode, this.key, this.value);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        HashIndexBucketV2 bucket = new HashIndexBucketV2(cacheEntry);
        boolean result = bucket.addEntry(this.index, this.hashCode, this.key, this.value);
        if (!result) {
            throw new IllegalStateException("Can not undo delete entry operation");
        }
    }

    @Override
    public int getId() {
        return 176;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8 + 12 + this.key.length + this.value.length;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.putLong(this.hashCode);
        buffer.putInt(this.key.length);
        buffer.put(this.key);
        buffer.putInt(this.value.length);
        buffer.put(this.value);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        this.hashCode = buffer.getLong();
        int keyLen = buffer.getInt();
        this.key = new byte[keyLen];
        buffer.get(this.key);
        int valueLen = buffer.getInt();
        this.value = new byte[valueLen];
        buffer.get(this.value);
    }
}

