/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directorypage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.DirectoryPageV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2DirectoryPageSetNodeLocalDepthPO
extends PageOperationRecord {
    private int localNodeIndex;
    private byte nodeLocalDepth;
    private byte pastNodeLocalDepth;

    public LocalHashTableV2DirectoryPageSetNodeLocalDepthPO() {
    }

    public LocalHashTableV2DirectoryPageSetNodeLocalDepthPO(int localNodeIndex, byte nodeLocalDepth, byte pastNodeLocalDepth) {
        this.localNodeIndex = localNodeIndex;
        this.nodeLocalDepth = nodeLocalDepth;
        this.pastNodeLocalDepth = pastNodeLocalDepth;
    }

    public int getLocalNodeIndex() {
        return this.localNodeIndex;
    }

    public byte getNodeLocalDepth() {
        return this.nodeLocalDepth;
    }

    public byte getPastNodeLocalDepth() {
        return this.pastNodeLocalDepth;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        DirectoryPageV2 page = new DirectoryPageV2(cacheEntry);
        page.setNodeLocalDepth(this.localNodeIndex, this.nodeLocalDepth);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        DirectoryPageV2 page = new DirectoryPageV2(cacheEntry);
        page.setNodeLocalDepth(this.localNodeIndex, this.pastNodeLocalDepth);
    }

    @Override
    public int getId() {
        return 181;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 4 + 2;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.localNodeIndex);
        buffer.put(this.nodeLocalDepth);
        buffer.put(this.pastNodeLocalDepth);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.localNodeIndex = buffer.getInt();
        this.nodeLocalDepth = buffer.get();
        this.pastNodeLocalDepth = buffer.get();
    }
}

