/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.metadatapage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.HashIndexMetadataPageV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2MetadataPageSetRecordsCountPO
extends PageOperationRecord {
    private long recordsCount;
    private long pastRecordsCount;

    public LocalHashTableV2MetadataPageSetRecordsCountPO() {
    }

    public LocalHashTableV2MetadataPageSetRecordsCountPO(long recordsCount, long pastRecordsCount) {
        this.recordsCount = recordsCount;
        this.pastRecordsCount = pastRecordsCount;
    }

    public long getRecordsCount() {
        return this.recordsCount;
    }

    public long getPastRecordsCount() {
        return this.pastRecordsCount;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        HashIndexMetadataPageV2 page = new HashIndexMetadataPageV2(cacheEntry);
        page.setRecordsCount(this.recordsCount);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        HashIndexMetadataPageV2 page = new HashIndexMetadataPageV2(cacheEntry);
        page.setRecordsCount(this.pastRecordsCount);
    }

    @Override
    public int getId() {
        return 186;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putLong(this.recordsCount);
        buffer.putLong(this.pastRecordsCount);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.recordsCount = buffer.getLong();
        this.pastRecordsCount = buffer.getLong();
    }
}

