/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.nullbucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.HashIndexNullBucketV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2NullBucketRemoveValuePO
extends PageOperationRecord {
    private byte[] prevValue;

    public LocalHashTableV2NullBucketRemoveValuePO() {
    }

    public LocalHashTableV2NullBucketRemoveValuePO(byte[] prevValue) {
        this.prevValue = prevValue;
    }

    public byte[] getPrevValue() {
        return this.prevValue;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        HashIndexNullBucketV2 bucket = new HashIndexNullBucketV2(cacheEntry);
        bucket.removeValue(this.prevValue);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        HashIndexNullBucketV2 bucket = new HashIndexNullBucketV2(cacheEntry);
        bucket.setValue(this.prevValue, null);
    }

    @Override
    public int getId() {
        return 189;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 4 + this.prevValue.length;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.prevValue.length);
        buffer.put(this.prevValue);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        int prevValueLen = buffer.getInt();
        this.prevValue = new byte[prevValueLen];
        buffer.get(this.prevValue);
    }
}

