/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeBucketV1;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class SBTreeBucketV1ShrinkPO
extends PageOperationRecord {
    private int newSize;
    private List<byte[]> removedRecords;
    private boolean isEncrypted;
    private OBinarySerializer keySerializer;
    private OBinarySerializer valueSerializer;

    public SBTreeBucketV1ShrinkPO() {
    }

    public SBTreeBucketV1ShrinkPO(int newSize, List<byte[]> removedRecords, boolean isEncrypted, OBinarySerializer keySerializer, OBinarySerializer valueSerializer) {
        this.newSize = newSize;
        this.removedRecords = removedRecords;
        this.isEncrypted = isEncrypted;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public int getNewSize() {
        return this.newSize;
    }

    public List<byte[]> getRemovedRecords() {
        return this.removedRecords;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public OBinarySerializer getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
        bucket.shrink(this.newSize, this.isEncrypted, this.keySerializer, this.valueSerializer);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
        bucket.addAll(this.removedRecords, this.isEncrypted, this.keySerializer, this.valueSerializer);
    }

    @Override
    public int getId() {
        return 100;
    }

    @Override
    public int serializedSize() {
        int serializedSize = 11 + this.removedRecords.size() * 4;
        for (byte[] record : this.removedRecords) {
            serializedSize += record.length;
        }
        return super.serializedSize() + serializedSize;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.newSize);
        buffer.putInt(this.removedRecords.size());
        for (byte[] record : this.removedRecords) {
            buffer.putInt(record.length);
            buffer.put(record);
        }
        buffer.put(this.isEncrypted ? (byte)1 : 0);
        buffer.put(this.keySerializer.getId());
        buffer.put(this.valueSerializer.getId());
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.newSize = buffer.getInt();
        int records = buffer.getInt();
        this.removedRecords = new ArrayList<byte[]>();
        for (int i = 0; i < records; ++i) {
            int recordLen = buffer.getInt();
            byte[] record = new byte[recordLen];
            buffer.get(record);
            this.removedRecords.add(record);
        }
        this.isEncrypted = buffer.get() > 0;
        this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
        this.valueSerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
    }
}

