/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.nullbucket;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeNullBucketV1;
import java.nio.ByteBuffer;

public final class SBTreeNullBucketV1RemoveValuePO
extends PageOperationRecord {
    private byte[] value;
    private OBinarySerializer valueSerializer;

    public SBTreeNullBucketV1RemoveValuePO() {
    }

    public SBTreeNullBucketV1RemoveValuePO(byte[] value, OBinarySerializer valueSerializer) {
        this.value = value;
        this.valueSerializer = valueSerializer;
    }

    public byte[] getValue() {
        return this.value;
    }

    public OBinarySerializer getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OSBTreeNullBucketV1 bucket = new OSBTreeNullBucketV1(cacheEntry);
        bucket.removeValue(this.valueSerializer);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OSBTreeNullBucketV1 bucket = new OSBTreeNullBucketV1(cacheEntry);
        bucket.setValue(this.value, this.valueSerializer);
    }

    @Override
    public int getId() {
        return 107;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + this.value.length + 4 + 1;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.value.length);
        buffer.put(this.value);
        buffer.put(this.valueSerializer.getId());
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        int valueLen = buffer.getInt();
        this.value = new byte[valueLen];
        buffer.get(this.value);
        this.valueSerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
    }
}

