/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.nullbucket;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeNullBucketV1;
import java.nio.ByteBuffer;

public class SBTreeNullBucketV1SetValuePO
extends PageOperationRecord {
    private byte[] prevValue;
    private byte[] value;
    private OBinarySerializer valueSerializer;

    public SBTreeNullBucketV1SetValuePO() {
    }

    public SBTreeNullBucketV1SetValuePO(byte[] prevValue, byte[] value, OBinarySerializer valueSerializer) {
        this.prevValue = prevValue;
        this.value = value;
        this.valueSerializer = valueSerializer;
    }

    public byte[] getPrevValue() {
        return this.prevValue;
    }

    public byte[] getValue() {
        return this.value;
    }

    public OBinarySerializer getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OSBTreeNullBucketV1 bucket = new OSBTreeNullBucketV1(cacheEntry);
        bucket.setValue(this.value, this.valueSerializer);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OSBTreeNullBucketV1 bucket = new OSBTreeNullBucketV1(cacheEntry);
        if (this.prevValue == null) {
            bucket.removeValue(this.valueSerializer);
        } else {
            bucket.setValue(this.prevValue, this.valueSerializer);
        }
    }

    @Override
    public int getId() {
        return 106;
    }

    @Override
    public int serializedSize() {
        int size = 6 + this.value.length;
        if (this.prevValue != null) {
            size += this.prevValue.length + 4;
        }
        return super.serializedSize() + size;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.value.length);
        buffer.put(this.value);
        buffer.put(this.valueSerializer.getId());
        buffer.put(this.prevValue == null ? (byte)0 : 1);
        if (this.prevValue != null) {
            buffer.putInt(this.prevValue.length);
            buffer.put(this.prevValue);
        }
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        int valueLength = buffer.getInt();
        this.value = new byte[valueLength];
        buffer.get(this.value);
        this.valueSerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
        if (buffer.get() > 0) {
            int prevValueLen = buffer.getInt();
            this.prevValue = new byte[prevValueLen];
            buffer.get(this.prevValue);
        }
    }
}

