/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v2.OSBTreeBucketV2;
import java.nio.ByteBuffer;

public final class SBTreeBucketV2RemoveLeafEntryPO
extends PageOperationRecord {
    private int index;
    private byte[] key;
    private byte[] value;

    public SBTreeBucketV2RemoveLeafEntryPO() {
    }

    public SBTreeBucketV2RemoveLeafEntryPO(int index, byte[] key, byte[] value) {
        this.index = index;
        this.key = key;
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OSBTreeBucketV2 bucket = new OSBTreeBucketV2(cacheEntry);
        bucket.removeLeafEntry(this.index, this.key, this.value);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OSBTreeBucketV2 bucket = new OSBTreeBucketV2(cacheEntry);
        bucket.addLeafEntry(this.index, this.key, this.value);
    }

    @Override
    public int getId() {
        return 112;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 12 + this.key.length + this.value.length;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.putInt(this.key.length);
        buffer.put(this.key);
        buffer.putInt(this.value.length);
        buffer.put(this.value);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        int keyLen = buffer.getInt();
        this.key = new byte[keyLen];
        buffer.get(this.key);
        int valueLen = buffer.getInt();
        this.value = new byte[valueLen];
        buffer.get(this.value);
    }
}

