/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.engine;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.OIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashFunction;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashTable;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OMurmurHash3HashFunction;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OSHA256HashFunction;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.LocalHashTableV2;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v3.OLocalHashTableV3;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class OHashTableIndexEngine
implements OIndexEngine {
    public static final int VERSION = 3;
    public static final String METADATA_FILE_EXTENSION = ".him";
    public static final String TREE_FILE_EXTENSION = ".hit";
    public static final String BUCKET_FILE_EXTENSION = ".hib";
    public static final String NULL_BUCKET_FILE_EXTENSION = ".hnb";
    private final OHashTable<Object, Object> hashTable;
    private final AtomicLong bonsayFileId = new AtomicLong(0L);
    private final String name;
    private final int id;

    public OHashTableIndexEngine(String name, int id, OAbstractPaginatedStorage storage, int version) {
        this.id = id;
        if (version < 2) {
            throw new IllegalStateException("Unsupported version of hash index");
        }
        if (version == 2) {
            this.hashTable = new LocalHashTableV2<Object, Object>(name, METADATA_FILE_EXTENSION, TREE_FILE_EXTENSION, BUCKET_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
        } else if (version == 3) {
            this.hashTable = new OLocalHashTableV3<Object, Object>(name, METADATA_FILE_EXTENSION, TREE_FILE_EXTENSION, BUCKET_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
        } else {
            throw new IllegalStateException("Invalid value of the index version , version = " + version);
        }
        this.name = name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void create(OAtomicOperation atomicOperation, OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Map<String, String> engineProperties, OEncryption encryption) throws IOException {
        OHashFunction hashFunction = encryption != null ? new OSHA256HashFunction(keySerializer) : new OMurmurHash3HashFunction(keySerializer);
        this.hashTable.create(atomicOperation, keySerializer, valueSerializer, keyTypes, encryption, hashFunction, nullPointerSupport);
    }

    @Override
    public void flush() {
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.name;
    }

    @Override
    public void delete(OAtomicOperation atomicOperation) throws IOException {
        this.doClearTable(atomicOperation);
        this.hashTable.delete(atomicOperation);
    }

    private void doClearTable(OAtomicOperation atomicOperation) throws IOException {
        OHashTable.Entry<Object, Object> firstEntry = this.hashTable.firstEntry();
        if (firstEntry != null) {
            OHashTable.Entry<Object, Object>[] entries = this.hashTable.ceilingEntries(firstEntry.key);
            while (entries.length > 0) {
                for (OHashTable.Entry<Object, Object> entry : entries) {
                    this.hashTable.remove(atomicOperation, entry.key);
                }
                entries = this.hashTable.higherEntries(entries[entries.length - 1].key);
            }
        }
        if (this.hashTable.isNullKeyIsSupported()) {
            this.hashTable.remove(atomicOperation, null);
        }
    }

    @Override
    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        OHashFunction hashFunction = encryption != null ? new OSHA256HashFunction(keySerializer) : new OMurmurHash3HashFunction(keySerializer);
        this.hashTable.load(indexName, keyTypes, nullPointerSupport, encryption, hashFunction, keySerializer, valueSerializer);
    }

    @Override
    public boolean remove(OAtomicOperation atomicOperation, Object key) throws IOException {
        return this.hashTable.remove(atomicOperation, key) != null;
    }

    @Override
    public void clear(OAtomicOperation atomicOperation) throws IOException {
        this.doClearTable(atomicOperation);
    }

    @Override
    public void close() {
        this.hashTable.close();
    }

    @Override
    public Object get(Object key) {
        return this.hashTable.get(key);
    }

    @Override
    public void put(OAtomicOperation atomicOperation, Object key, Object value) throws IOException {
        this.hashTable.put(atomicOperation, key, value);
    }

    @Override
    public void update(OAtomicOperation atomicOperation, Object key, OIndexKeyUpdater<Object> updater) throws IOException {
        Object value = this.get(key);
        OIndexUpdateAction<Object> updated = updater.update(value, this.bonsayFileId);
        if (updated.isChange()) {
            this.put(atomicOperation, key, updated.getValue());
        } else if (updated.isRemove()) {
            this.remove(atomicOperation, key);
        } else if (updated.isNothing()) {
            // empty if block
        }
    }

    @Override
    public boolean validatedPut(OAtomicOperation atomicOperation, Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) throws IOException {
        return this.hashTable.validatedPut(atomicOperation, key, value, validator);
    }

    @Override
    public long size(OBaseIndexEngine.ValuesTransformer transformer) {
        OHashTable.Entry<Object, Object> firstEntry;
        Object nullValue;
        if (transformer == null) {
            return this.hashTable.size();
        }
        long counter = 0L;
        if (this.hashTable.isNullKeyIsSupported() && (nullValue = this.hashTable.get(null)) != null) {
            counter += (long)transformer.transformFromValue(nullValue).size();
        }
        if ((firstEntry = this.hashTable.firstEntry()) == null) {
            return counter;
        }
        OHashTable.Entry<Object, Object>[] entries = this.hashTable.ceilingEntries(firstEntry.key);
        while (entries.length > 0) {
            for (OHashTable.Entry<Object, Object> entry : entries) {
                counter += (long)transformer.transformFromValue(entry.value).size();
            }
            entries = this.hashTable.higherEntries(entries[entries.length - 1].key);
        }
        return counter;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return false;
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesBetween");
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesMajor");
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesMinor");
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream(final OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        return StreamSupport.stream(new Spliterator<ORawPair<Object, ORID>>(){
            private int nextEntriesIndex;
            private OHashTable.Entry<Object, Object>[] entries;
            private Iterator<ORID> currentIterator = new OEmptyIterator<ORID>();
            private Object currentKey;
            {
                OHashTable.Entry firstEntry = OHashTableIndexEngine.this.hashTable.firstEntry();
                this.entries = firstEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : OHashTableIndexEngine.this.hashTable.ceilingEntries(firstEntry.key);
                if (this.entries.length == 0) {
                    this.currentIterator = null;
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super ORawPair<Object, ORID>> action) {
                if (this.currentIterator == null) {
                    return false;
                }
                if (this.currentIterator.hasNext()) {
                    OIdentifiable identifiable = this.currentIterator.next();
                    action.accept(new ORawPair<Object, ORID>(this.currentKey, identifiable.getIdentity()));
                    return true;
                }
                while (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    if (this.entries.length == 0) {
                        this.currentIterator = null;
                        return false;
                    }
                    OHashTable.Entry<Object, Object> bucketEntry = this.entries[this.nextEntriesIndex];
                    this.currentKey = bucketEntry.key;
                    Object value = bucketEntry.value;
                    this.currentIterator = valuesTransformer != null ? valuesTransformer.transformFromValue(value).iterator() : Collections.singletonList((ORID)value).iterator();
                    ++this.nextEntriesIndex;
                    if (this.nextEntriesIndex < this.entries.length) continue;
                    this.entries = OHashTableIndexEngine.this.hashTable.higherEntries(this.entries[this.entries.length - 1].key);
                    this.nextEntriesIndex = 0;
                }
                if (this.currentIterator != null) {
                    OIdentifiable identifiable = this.currentIterator.next();
                    action.accept(new ORawPair<Object, ORID>(this.currentKey, identifiable.getIdentity()));
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<ORawPair<Object, ORID>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 256;
            }
        }, false);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream(final OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        return StreamSupport.stream(new Spliterator<ORawPair<Object, ORID>>(){
            private int nextEntriesIndex;
            private OHashTable.Entry<Object, Object>[] entries;
            private Iterator<ORID> currentIterator = new OEmptyIterator<ORID>();
            private Object currentKey;
            {
                OHashTable.Entry lastEntry = OHashTableIndexEngine.this.hashTable.lastEntry();
                this.entries = lastEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : OHashTableIndexEngine.this.hashTable.floorEntries(lastEntry.key);
                if (this.entries.length == 0) {
                    this.currentIterator = null;
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super ORawPair<Object, ORID>> action) {
                if (this.currentIterator == null) {
                    return false;
                }
                if (this.currentIterator.hasNext()) {
                    OIdentifiable identifiable = this.currentIterator.next();
                    action.accept(new ORawPair<Object, ORID>(this.currentKey, identifiable.getIdentity()));
                    return true;
                }
                while (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    if (this.entries.length == 0) {
                        this.currentIterator = null;
                        return false;
                    }
                    OHashTable.Entry<Object, Object> bucketEntry = this.entries[this.nextEntriesIndex];
                    this.currentKey = bucketEntry.key;
                    Object value = bucketEntry.value;
                    this.currentIterator = valuesTransformer != null ? valuesTransformer.transformFromValue(value).iterator() : Collections.singletonList((ORID)value).iterator();
                    --this.nextEntriesIndex;
                    if (this.nextEntriesIndex >= 0) continue;
                    this.entries = OHashTableIndexEngine.this.hashTable.lowerEntries(this.entries[0].key);
                    this.nextEntriesIndex = this.entries.length - 1;
                }
                if (this.currentIterator != null) {
                    OIdentifiable identifiable = this.currentIterator.next();
                    action.accept(new ORawPair<Object, ORID>(this.currentKey, identifiable.getIdentity()));
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<ORawPair<Object, ORID>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 256;
            }
        }, false);
    }

    @Override
    public Stream<Object> keyStream() {
        return StreamSupport.stream(new Spliterator<Object>(){
            private int nextEntriesIndex;
            private OHashTable.Entry<Object, Object>[] entries;
            {
                OHashTable.Entry firstEntry = OHashTableIndexEngine.this.hashTable.firstEntry();
                this.entries = firstEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : OHashTableIndexEngine.this.hashTable.ceilingEntries(firstEntry.key);
            }

            @Override
            public boolean tryAdvance(Consumer<? super Object> action) {
                if (this.entries.length == 0) {
                    return false;
                }
                OHashTable.Entry<Object, Object> bucketEntry = this.entries[this.nextEntriesIndex];
                ++this.nextEntriesIndex;
                if (this.nextEntriesIndex >= this.entries.length) {
                    this.entries = OHashTableIndexEngine.this.hashTable.higherEntries(this.entries[this.entries.length - 1].key);
                    this.nextEntriesIndex = 0;
                }
                action.accept(bucketEntry.key);
                return true;
            }

            @Override
            public Spliterator<Object> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 256;
            }
        }, false);
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        this.hashTable.acquireAtomicExclusiveLock();
        return true;
    }
}

