/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.engine;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.OIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTree;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeV1;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v2.OSBTreeV2;
import java.io.IOException;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class OSBTreeIndexEngine
implements OIndexEngine {
    public static final int VERSION = 2;
    public static final String DATA_FILE_EXTENSION = ".sbt";
    public static final String NULL_BUCKET_FILE_EXTENSION = ".nbt";
    private final OSBTree<Object, Object> sbTree;
    private final String name;
    private final int id;

    public OSBTreeIndexEngine(int id, String name, OAbstractPaginatedStorage storage, int version) {
        this.id = id;
        this.name = name;
        if (version == 1) {
            this.sbTree = new OSBTreeV1<Object, Object>(name, DATA_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
        } else if (version == 2) {
            this.sbTree = new OSBTreeV2<Object, Object>(name, DATA_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
        } else {
            throw new IllegalStateException("Invalid version of index, version = " + version);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void flush() {
    }

    @Override
    public void create(OAtomicOperation atomicOperation, OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        try {
            this.sbTree.create(atomicOperation, keySerializer, valueSerializer, keyTypes, keySize, nullPointerSupport, encryption);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during creation of index " + this.name), e);
        }
    }

    @Override
    public void delete(OAtomicOperation atomicOperation) {
        try {
            this.doClearTree(atomicOperation);
            this.sbTree.delete(atomicOperation);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during deletion of index " + this.name), e);
        }
    }

    private void doClearTree(OAtomicOperation atomicOperation) throws IOException {
        try (Stream<Object> stream = this.sbTree.keyStream();){
            stream.forEach(key -> {
                try {
                    this.sbTree.remove(atomicOperation, key);
                }
                catch (IOException e) {
                    throw OException.wrapException(new OIndexException("Error during clearing a tree" + this.name), e);
                }
            });
        }
        if (this.sbTree.isNullPointerSupport()) {
            this.sbTree.remove(atomicOperation, null);
        }
    }

    @Override
    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        this.sbTree.load(indexName, keySerializer, valueSerializer, keyTypes, keySize, nullPointerSupport, encryption);
    }

    @Override
    public boolean remove(OAtomicOperation atomicOperation, Object key) {
        try {
            return this.sbTree.remove(atomicOperation, key) != null;
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during removal of key " + key + " from index " + this.name), e);
        }
    }

    @Override
    public void clear(OAtomicOperation atomicOperation) {
        try {
            this.doClearTree(atomicOperation);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during clear index " + this.name), e);
        }
    }

    @Override
    public void close() {
        this.sbTree.close();
    }

    @Override
    public Object get(Object key) {
        return this.sbTree.get(key);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        Object firstKey = this.sbTree.firstKey();
        if (firstKey == null) {
            return StreamSupport.stream(Spliterators.emptySpliterator(), false);
        }
        return OSBTreeIndexEngine.convertTreeStreamToIndexStream(valuesTransformer, this.sbTree.iterateEntriesMajor(firstKey, true, true));
    }

    private static Stream<ORawPair<Object, ORID>> convertTreeStreamToIndexStream(OBaseIndexEngine.ValuesTransformer valuesTransformer, Stream<ORawPair<Object, Object>> treeStream) {
        if (valuesTransformer == null) {
            return treeStream.map(entry -> new ORawPair(entry.first, (ORID)entry.second));
        }
        return treeStream.flatMap(entry -> valuesTransformer.transformFromValue(entry.second).stream().map(rid -> new ORawPair(entry.first, (ORID)rid)));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        Object lastKey = this.sbTree.lastKey();
        if (lastKey == null) {
            return StreamSupport.stream(Spliterators.emptySpliterator(), false);
        }
        return OSBTreeIndexEngine.convertTreeStreamToIndexStream(valuesTransformer, this.sbTree.iterateEntriesMinor(lastKey, true, false));
    }

    @Override
    public Stream<Object> keyStream() {
        return this.sbTree.keyStream();
    }

    @Override
    public void put(OAtomicOperation atomicOperation, Object key, Object value) {
        try {
            this.sbTree.put(atomicOperation, key, value);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during insertion of key " + key + " in index " + this.name), e);
        }
    }

    @Override
    public void update(OAtomicOperation atomicOperation, Object key, OIndexKeyUpdater<Object> updater) {
        try {
            this.sbTree.update(atomicOperation, key, updater, null);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during update of key " + key + " in index " + this.name), e);
        }
    }

    @Override
    public boolean validatedPut(OAtomicOperation atomicOperation, Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) {
        try {
            return this.sbTree.validatedPut(atomicOperation, key, value, validator);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during insertion of key " + key + " in index " + this.name), e);
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return OSBTreeIndexEngine.convertTreeStreamToIndexStream(transformer, this.sbTree.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return OSBTreeIndexEngine.convertTreeStreamToIndexStream(transformer, this.sbTree.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return OSBTreeIndexEngine.convertTreeStreamToIndexStream(transformer, this.sbTree.iterateEntriesMinor(toKey, isInclusive, ascSortOrder));
    }

    @Override
    public long size(OBaseIndexEngine.ValuesTransformer transformer) {
        Object nullValue;
        if (transformer == null) {
            return this.sbTree.size();
        }
        int counter = 0;
        if (this.sbTree.isNullPointerSupport() && (nullValue = this.sbTree.get(null)) != null) {
            counter += transformer.transformFromValue(nullValue).size();
        }
        Object firstKey = this.sbTree.firstKey();
        Object lastKey = this.sbTree.lastKey();
        if (firstKey != null && lastKey != null) {
            try (Stream<ORawPair<Object, Object>> stream = this.sbTree.iterateEntriesBetween(firstKey, true, lastKey, true, true);){
            }
            return counter += stream.mapToInt(pair -> transformer.transformFromValue(pair.second).size()).sum();
        }
        return counter;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return true;
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        this.sbTree.acquireAtomicExclusiveLock();
        return true;
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.name;
    }
}

