/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local.v2;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directoryfirstpage.LocalHashTableV2DirectoryFirstPageSetMaxLeftChildDepthPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directoryfirstpage.LocalHashTableV2DirectoryFirstPageSetMaxRightChildDepthPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directoryfirstpage.LocalHashTableV2DirectoryFirstPageSetNodeLocalDepthPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directoryfirstpage.LocalHashTableV2DirectoryFirstPageSetPointerPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directoryfirstpage.LocalHashTableV2DirectoryFirstPageSetTombstonePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directoryfirstpage.LocalHashTableV2DirectoryFirstPageSetTreeSizePO;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.DirectoryPageV2;

public final class DirectoryFirstPageV2
extends DirectoryPageV2 {
    private static final int TREE_SIZE_OFFSET = 28;
    private static final int TOMBSTONE_OFFSET = 32;
    private static final int ITEMS_OFFSET = 36;
    static final int NODES_PER_PAGE = (OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024 - 36) / 2051;

    public DirectoryFirstPageV2(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void setTreeSize(int treeSize) {
        int pastSize = this.getIntValue(28);
        this.setIntValue(28, treeSize);
        this.addPageOperation(new LocalHashTableV2DirectoryFirstPageSetTreeSizePO(treeSize, pastSize));
    }

    public int getTreeSize() {
        return this.getIntValue(28);
    }

    public void setTombstone(int tombstone) {
        int pastTombstone = this.getIntValue(32);
        this.setIntValue(32, tombstone);
        this.addPageOperation(new LocalHashTableV2DirectoryFirstPageSetTombstonePO(tombstone, pastTombstone));
    }

    public int getTombstone() {
        return this.getIntValue(32);
    }

    @Override
    protected int getItemsOffset() {
        return 36;
    }

    @Override
    protected void logSetMaxLeftChildDepth(int localNodeIndex, byte maxLeftChildDepth, byte pastDepth) {
        this.addPageOperation(new LocalHashTableV2DirectoryFirstPageSetMaxLeftChildDepthPO(localNodeIndex, maxLeftChildDepth, pastDepth));
    }

    @Override
    protected void logSetMaxRightChildDepth(int localNodeIndex, byte maxRightChildDepth, byte pastDepth) {
        this.addPageOperation(new LocalHashTableV2DirectoryFirstPageSetMaxRightChildDepthPO(localNodeIndex, maxRightChildDepth, pastDepth));
    }

    @Override
    protected void logSetNodeLocalDepth(int localNodeIndex, byte nodeLocalDepth, byte pastDepth) {
        this.addPageOperation(new LocalHashTableV2DirectoryFirstPageSetNodeLocalDepthPO(localNodeIndex, nodeLocalDepth, pastDepth));
    }

    @Override
    protected void logSetPointer(int localNodeIndex, int index, long pointer, long pastPointer) {
        this.addPageOperation(new LocalHashTableV2DirectoryFirstPageSetPointerPO(localNodeIndex, index, pointer, pastPointer));
    }
}

