/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local.v2;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directorypage.LocalHashTableV2DirectoryPageSetMaxLeftChildDepthPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directorypage.LocalHashTableV2DirectoryPageSetMaxRightChildDepthPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directorypage.LocalHashTableV2DirectoryPageSetNodeLocalDepthPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directorypage.LocalHashTableV2DirectoryPageSetPointerPO;

public class DirectoryPageV2
extends ODurablePage {
    private static final int ITEMS_OFFSET = 28;
    static final int NODES_PER_PAGE = (OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024 - 28) / 2051;

    public DirectoryPageV2(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void setMaxLeftChildDepth(int localNodeIndex, byte maxLeftChildDepth) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051;
        byte pastDepth = this.getByteValue(offset);
        this.setByteValue(offset, maxLeftChildDepth);
        this.logSetMaxLeftChildDepth(localNodeIndex, maxLeftChildDepth, pastDepth);
    }

    protected void logSetMaxLeftChildDepth(int localNodeIndex, byte maxLeftChildDepth, byte pastDepth) {
        this.addPageOperation(new LocalHashTableV2DirectoryPageSetMaxLeftChildDepthPO(localNodeIndex, maxLeftChildDepth, pastDepth));
    }

    public byte getMaxLeftChildDepth(int localNodeIndex) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051;
        return this.getByteValue(offset);
    }

    public void setMaxRightChildDepth(int localNodeIndex, byte maxRightChildDepth) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051 + 1;
        byte pastDepth = this.getByteValue(offset);
        this.setByteValue(offset, maxRightChildDepth);
        this.logSetMaxRightChildDepth(localNodeIndex, maxRightChildDepth, pastDepth);
    }

    protected void logSetMaxRightChildDepth(int localNodeIndex, byte maxRightChildDepth, byte pastDepth) {
        this.addPageOperation(new LocalHashTableV2DirectoryPageSetMaxRightChildDepthPO(localNodeIndex, maxRightChildDepth, pastDepth));
    }

    public byte getMaxRightChildDepth(int localNodeIndex) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051 + 1;
        return this.getByteValue(offset);
    }

    public void setNodeLocalDepth(int localNodeIndex, byte nodeLocalDepth) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051 + 2;
        byte pastDepth = this.getByteValue(offset);
        this.setByteValue(offset, nodeLocalDepth);
        this.logSetNodeLocalDepth(localNodeIndex, nodeLocalDepth, pastDepth);
    }

    protected void logSetNodeLocalDepth(int localNodeIndex, byte nodeLocalDepth, byte pastDepth) {
        this.addPageOperation(new LocalHashTableV2DirectoryPageSetNodeLocalDepthPO(localNodeIndex, nodeLocalDepth, pastDepth));
    }

    public byte getNodeLocalDepth(int localNodeIndex) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051 + 2;
        return this.getByteValue(offset);
    }

    public void setPointer(int localNodeIndex, int index, long pointer) {
        int offset = this.getItemsOffset() + (localNodeIndex * 2051 + 3) + index * 8;
        long pastPointer = this.getLongValue(offset);
        this.setLongValue(offset, pointer);
        this.logSetPointer(localNodeIndex, index, pointer, pastPointer);
    }

    protected void logSetPointer(int localNodeIndex, int index, long pointer, long pastPointer) {
        this.addPageOperation(new LocalHashTableV2DirectoryPageSetPointerPO(localNodeIndex, index, pointer, pastPointer));
    }

    public long getPointer(int localNodeIndex, int index) {
        int offset = this.getItemsOffset() + (localNodeIndex * 2051 + 3) + index * 8;
        return this.getLongValue(offset);
    }

    protected int getItemsOffset() {
        return 28;
    }
}

