/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local.v2;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.bucket.LocalHashTableV2BucketAddEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.bucket.LocalHashTableV2BucketDeleteEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.bucket.LocalHashTableV2BucketInitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.bucket.LocalHashTableV2BucketSetDepthPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.bucket.LocalHashTableV2BucketUpdateEntryPO;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashTable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class HashIndexBucketV2<K, V>
extends ODurablePage {
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int DEPTH_OFFSET = 32;
    private static final int SIZE_OFFSET = 33;
    private static final int HISTORY_OFFSET = 37;
    private static final int NEXT_REMOVED_BUCKET_OFFSET = 549;
    private static final int POSITIONS_ARRAY_OFFSET = 557;
    private static final int MAX_BUCKET_SIZE_BYTES = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    private final Comparator keyComparator = ODefaultComparator.INSTANCE;

    public HashIndexBucketV2(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init(int depth) {
        this.setByteValue(32, (byte)depth);
        this.setIntValue(28, MAX_BUCKET_SIZE_BYTES);
        this.setIntValue(33, 0);
        this.addPageOperation(new LocalHashTableV2BucketInitPO(depth));
    }

    public OHashTable.Entry<K, V> find(K key, long hashCode, OEncryption encryption, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        int index = this.binarySearch(key, hashCode, encryption, keySerializer);
        if (index < 0) {
            return null;
        }
        return this.getEntry(index, encryption, keySerializer, valueSerializer);
    }

    private int binarySearch(K key, long hashCode, OEncryption encryption, OBinarySerializer<K> keySerializer) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            long midHashCode = this.getHashCode(mid);
            if (HashIndexBucketV2.lessThanUnsigned(midHashCode, hashCode)) {
                cmp = -1;
            } else if (HashIndexBucketV2.greaterThanUnsigned(midHashCode, hashCode)) {
                cmp = 1;
            } else {
                K midVal = this.getKey(mid, encryption, keySerializer);
                cmp = this.keyComparator.compare(midVal, key);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static boolean lessThanUnsigned(long longOne, long longTwo) {
        return longOne + Long.MIN_VALUE < longTwo + Long.MIN_VALUE;
    }

    private static boolean greaterThanUnsigned(long longOne, long longTwo) {
        return longOne + Long.MIN_VALUE > longTwo + Long.MIN_VALUE;
    }

    public OHashTable.Entry<K, V> getEntry(int index, OEncryption encryption, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        K key;
        int entryPosition = this.getIntValue(557 + index * 4);
        long hashCode = this.getLongValue(entryPosition);
        entryPosition += 8;
        if (encryption == null) {
            key = this.deserializeFromDirectMemory(keySerializer, entryPosition);
            entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
        } else {
            int encryptedLength = this.getIntValue(entryPosition);
            byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptedLength);
            entryPosition += encryptedLength;
            byte[] binaryKey = encryption.decrypt(encryptedKey);
            key = keySerializer.deserializeNativeObject(binaryKey, 0);
        }
        V value = this.deserializeFromDirectMemory(valueSerializer, entryPosition);
        return new OHashTable.Entry<K, V>(key, value, hashCode);
    }

    public OHashTable.RawEntry getRawEntry(int index, OEncryption encryption, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        byte[] key;
        int entryPosition = this.getIntValue(557 + index * 4);
        long hashCode = this.getLongValue(entryPosition);
        entryPosition += 8;
        if (encryption == null) {
            int keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
            key = this.getBinaryValue(entryPosition, keySize);
            entryPosition += keySize;
        } else {
            int encryptedLength = this.getIntValue(entryPosition);
            key = this.getBinaryValue(entryPosition, encryptedLength + 4);
            entryPosition += encryptedLength + 4;
        }
        int valueSize = this.getObjectSizeInDirectMemory(valueSerializer, entryPosition);
        byte[] value = this.getBinaryValue(entryPosition, valueSize);
        return new OHashTable.RawEntry(key, value, hashCode);
    }

    public byte[] getRawValue(int index, int keySize, OBinarySerializer<V> valueSerializer) {
        int entryPosition = this.getIntValue(557 + index * 4);
        int rawSize = this.getObjectSizeInDirectMemory(valueSerializer, entryPosition += 8 + keySize);
        return this.getBinaryValue(entryPosition, rawSize);
    }

    public V getValue(int index, OEncryption encryption, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        int entryPosition = this.getIntValue(557 + index * 4);
        entryPosition += 8;
        if (encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
        } else {
            int encryptedLength = this.getIntValue(entryPosition);
            entryPosition += encryptedLength + 4;
        }
        return this.deserializeFromDirectMemory(valueSerializer, entryPosition);
    }

    private long getHashCode(int index) {
        int entryPosition = this.getIntValue(557 + index * 4);
        return this.getLongValue(entryPosition);
    }

    public K getKey(int index, OEncryption encryption, OBinarySerializer<K> keySerializer) {
        int entryPosition = this.getIntValue(557 + index * 4);
        if (encryption == null) {
            return this.deserializeFromDirectMemory(keySerializer, entryPosition + 8);
        }
        int encryptedLength = this.getIntValue(entryPosition + 8);
        byte[] encryptedBinaryKey = this.getBinaryValue(entryPosition + 8 + 4, encryptedLength);
        byte[] decryptedBinaryKey = encryption.decrypt(encryptedBinaryKey);
        return keySerializer.deserializeNativeObject(decryptedBinaryKey, 0);
    }

    public int getIndex(long hashCode, K key, OEncryption encryption, OBinarySerializer<K> keySerializer) {
        return this.binarySearch(key, hashCode, encryption, keySerializer);
    }

    public int size() {
        return this.getIntValue(33);
    }

    public Iterator<OHashTable.RawEntry> iterator(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OEncryption encryption) {
        return new RawEntryIterator(0, keySerializer, valueSerializer, encryption);
    }

    public Iterator<OHashTable.Entry<K, V>> iterator(int index, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OEncryption encryption) {
        return new EntryIterator(index, keySerializer, valueSerializer, encryption);
    }

    public int getContentSize() {
        return 557 + this.size() * 4 + (MAX_BUCKET_SIZE_BYTES - this.getIntValue(28));
    }

    public int updateEntry(int index, byte[] value, byte[] oldValue, int keySize) {
        int entryPosition = this.getIntValue(557 + index * 4);
        entryPosition += 8 + keySize;
        if (oldValue.length != value.length) {
            return -1;
        }
        if (ODefaultComparator.INSTANCE.compare(oldValue, value) == 0) {
            return 0;
        }
        this.setBinaryValue(entryPosition, value);
        this.addPageOperation(new LocalHashTableV2BucketUpdateEntryPO(index, value, oldValue, keySize));
        return 1;
    }

    public void deleteEntry(int index, long hashCode, byte[] key, byte[] value) {
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IllegalStateException("Can not delete entry outside of border of the bucket");
        }
        int freePointer = this.getIntValue(28);
        int positionOffset = 557 + index * 4;
        int entryPosition = this.getIntValue(positionOffset);
        int entrySize = key.length + value.length + 8;
        this.moveData(positionOffset + 4, positionOffset, this.size() * 4 - (index + 1) * 4);
        if (entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        int currentPositionOffset = 557;
        for (int i = 0; i < size - 1; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        this.setIntValue(28, freePointer + entrySize);
        this.setIntValue(33, size - 1);
        this.addPageOperation(new LocalHashTableV2BucketDeleteEntryPO(index, hashCode, key, value));
    }

    public boolean addEntry(int index, long hashCode, byte[] key, byte[] value) {
        int entreeSize = key.length + value.length + 8;
        int freePointer = this.getIntValue(28);
        int size = this.size();
        if (index < 0 || index > size) {
            throw new IllegalStateException("Can not insert entry outside of border of bucket");
        }
        if (freePointer - entreeSize < 557 + (size + 1) * 4) {
            return false;
        }
        this.insertEntry(hashCode, key, value, index, entreeSize);
        this.addPageOperation(new LocalHashTableV2BucketAddEntryPO(index, hashCode, key, value));
        return true;
    }

    private void insertEntry(long hashCode, byte[] key, byte[] value, int insertionPoint, int entreeSize) {
        int freePointer = this.getIntValue(28);
        int size = this.size();
        int positionsOffset = insertionPoint * 4 + 557;
        this.moveData(positionsOffset, positionsOffset + 4, this.size() * 4 - insertionPoint * 4);
        int entreePosition = freePointer - entreeSize;
        this.setIntValue(positionsOffset, entreePosition);
        this.serializeEntry(hashCode, key, value, entreePosition);
        this.setIntValue(28, entreePosition);
        this.setIntValue(33, size + 1);
    }

    private void serializeEntry(long hashCode, byte[] key, byte[] value, int entryOffset) {
        this.setLongValue(entryOffset, hashCode);
        this.setBinaryValue(entryOffset += 8, key);
        this.setBinaryValue(entryOffset += key.length, value);
    }

    public int getDepth() {
        return this.getByteValue(32);
    }

    public void setDepth(int depth) {
        byte oldDepth = this.getByteValue(32);
        this.setByteValue(32, (byte)depth);
        this.addPageOperation(new LocalHashTableV2BucketSetDepthPO((byte)depth, oldDepth));
    }

    private final class RawEntryIterator
    implements Iterator<OHashTable.RawEntry> {
        private int currentIndex;
        private final OBinarySerializer<K> keySerializer;
        private final OBinarySerializer<V> valueSerializer;
        private final OEncryption encryption;

        private RawEntryIterator(int currentIndex, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OEncryption encryption) {
            this.currentIndex = currentIndex;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.encryption = encryption;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < HashIndexBucketV2.this.size();
        }

        @Override
        public OHashTable.RawEntry next() {
            if (this.currentIndex >= HashIndexBucketV2.this.size()) {
                throw new NoSuchElementException("Iterator was reached last element");
            }
            OHashTable.RawEntry entry = HashIndexBucketV2.this.getRawEntry(this.currentIndex, this.encryption, this.keySerializer, this.valueSerializer);
            ++this.currentIndex;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported");
        }
    }

    private final class EntryIterator
    implements Iterator<OHashTable.Entry<K, V>> {
        private int currentIndex;
        private final OBinarySerializer<K> keySerializer;
        private final OBinarySerializer<V> valueSerializer;
        private final OEncryption encryption;

        private EntryIterator(int currentIndex, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OEncryption encryption) {
            this.currentIndex = currentIndex;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.encryption = encryption;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < HashIndexBucketV2.this.size();
        }

        @Override
        public OHashTable.Entry<K, V> next() {
            if (this.currentIndex >= HashIndexBucketV2.this.size()) {
                throw new NoSuchElementException("Iterator was reached last element");
            }
            OHashTable.Entry entry = HashIndexBucketV2.this.getEntry(this.currentIndex, this.encryption, this.keySerializer, this.valueSerializer);
            ++this.currentIndex;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported");
        }
    }
}

