/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree;

import com.orientechnologies.orient.core.storage.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OMixedIndexRIDContainer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

public class OSBTreeMapEntryIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private LinkedList<Map.Entry<K, V>> preFetchedValues;
    private final OTreeInternal<K, V> sbTree;
    private K firstKey;
    private final int prefetchSize;

    public OSBTreeMapEntryIterator(OTreeInternal<K, V> sbTree) {
        this(sbTree, 8000);
    }

    private OSBTreeMapEntryIterator(OTreeInternal<K, V> sbTree, int prefetchSize) {
        this.sbTree = sbTree;
        this.prefetchSize = prefetchSize;
        if (sbTree.size() == 0L) {
            this.preFetchedValues = null;
            return;
        }
        this.preFetchedValues = new LinkedList();
        this.firstKey = sbTree.firstKey();
        this.prefetchData(true);
    }

    private void prefetchData(boolean firstTime) {
        this.sbTree.loadEntriesMajor(this.firstKey, firstTime, true, entry -> {
            Object value = entry.getValue();
            final Object resultValue = value instanceof OIndexRIDContainer || value instanceof OMixedIndexRIDContainer ? new HashSet((Collection)value) : value;
            this.preFetchedValues.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    return resultValue;
                }

                @Override
                public V setValue(V v) {
                    throw new UnsupportedOperationException("setValue");
                }
            });
            return this.preFetchedValues.size() <= this.prefetchSize;
        });
        if (this.preFetchedValues.isEmpty()) {
            this.preFetchedValues = null;
        } else {
            this.firstKey = this.preFetchedValues.getLast().getKey();
        }
    }

    @Override
    public boolean hasNext() {
        return this.preFetchedValues != null;
    }

    @Override
    public Map.Entry<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Map.Entry<K, V> entry = this.preFetchedValues.removeFirst();
        if (this.preFetchedValues.isEmpty()) {
            this.prefetchData(false);
        }
        return entry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

