/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.local.v2;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2AddAllPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2AddLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2AddNonLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2InitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2RemoveLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2RemoveNonLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2SetLeftSiblingPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2SetRightSiblingPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2SetTreeSizePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2ShrinkPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2SwitchBucketTypePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket.SBTreeBucketV2UpdateValuePO;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v2.OSBTreeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class OSBTreeBucketV2<K, V>
extends ODurablePage {
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int SIZE_OFFSET = 32;
    private static final int IS_LEAF_OFFSET = 36;
    private static final int LEFT_SIBLING_OFFSET = 37;
    private static final int RIGHT_SIBLING_OFFSET = 45;
    private static final int TREE_SIZE_OFFSET = 53;
    private static final int KEY_SERIALIZER_OFFSET = 61;
    private static final int VALUE_SERIALIZER_OFFSET = 62;
    private static final int FREE_VALUES_LIST_OFFSET = 63;
    private static final int POSITIONS_ARRAY_OFFSET = 71;

    public OSBTreeBucketV2(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init(boolean isLeaf) {
        this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(32, 0);
        this.setByteValue(36, (byte)(isLeaf ? 1 : 0));
        this.setLongValue(37, -1L);
        this.setLongValue(45, -1L);
        this.setLongValue(53, 0L);
        this.setLongValue(63, -1L);
        this.addPageOperation(new SBTreeBucketV2InitPO(isLeaf));
    }

    public void switchBucketType() {
        if (!this.isEmpty()) {
            throw new IllegalStateException("Type of bucket can be changed only bucket if bucket is empty");
        }
        boolean isLeaf = this.isLeaf();
        if (isLeaf) {
            this.setByteValue(36, (byte)0);
        } else {
            this.setByteValue(36, (byte)1);
        }
        this.addPageOperation(new SBTreeBucketV2SwitchBucketTypePO());
    }

    public void setTreeSize(long size) {
        long prevTreeSize = this.getLongValue(53);
        this.setLongValue(53, size);
        this.addPageOperation(new SBTreeBucketV2SetTreeSizePO(prevTreeSize, size));
    }

    public long getTreeSize() {
        return this.getLongValue(53);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int find(K key, OBinarySerializer<K> keySerializer) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = this.getKey(mid, keySerializer);
            int cmp = ODefaultComparator.INSTANCE.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void removeLeafEntry(int entryIndex, byte[] oldRawKey, byte[] oldRawValue) {
        if (!this.isLeaf()) {
            throw new IllegalStateException("This remove method is applied to leaf buckets only.");
        }
        int entryPosition = this.getIntValue(71 + entryIndex * 4);
        int entrySize = oldRawKey.length + oldRawValue.length + 1;
        int size = this.getIntValue(32);
        if (entryIndex < size - 1) {
            this.moveData(71 + (entryIndex + 1) * 4, 71 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(28, freePointer + entrySize);
        int currentPositionOffset = 71;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        this.addPageOperation(new SBTreeBucketV2RemoveLeafEntryPO(entryIndex, oldRawKey, oldRawValue));
    }

    public void removeNonLeafEntry(int entryIndex, byte[] key, int prevChild) {
        if (this.isLeaf()) {
            throw new IllegalStateException("This remove method is applied to non-leaf buckets only.");
        }
        int entryPosition = this.getIntValue(71 + entryIndex * 4);
        int entrySize = key.length + 16;
        int leftChild = (int)this.getLongValue(entryPosition);
        int rightChild = (int)this.getLongValue(entryPosition + 8);
        int size = this.getIntValue(32);
        if (entryIndex < size - 1) {
            this.moveData(71 + (entryIndex + 1) * 4, 71 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(28, freePointer + entrySize);
        int currentPositionOffset = 71;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        if (prevChild >= 0) {
            if (entryIndex > 0) {
                int prevEntryPosition = this.getIntValue(71 + (entryIndex - 1) * 4);
                this.setLongValue(prevEntryPosition + 8, prevChild);
            }
            if (entryIndex < size) {
                int nextEntryPosition = this.getIntValue(71 + entryIndex * 4);
                this.setLongValue(nextEntryPosition, prevChild);
            }
        }
        this.addPageOperation(new SBTreeBucketV2RemoveNonLeafEntryPO(entryIndex, prevChild, key, leftChild, rightChild));
    }

    public int size() {
        return this.getIntValue(32);
    }

    public SBTreeEntry<K, V> getEntry(int entryIndex, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        int entryPosition = this.getIntValue(entryIndex * 4 + 71);
        if (this.isLeaf()) {
            K key = this.deserializeFromDirectMemory(keySerializer, entryPosition);
            boolean isLinkValue = this.getByteValue(entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition)) > 0;
            long link = -1L;
            Object value = null;
            if (isLinkValue) {
                link = this.deserializeFromDirectMemory(OLongSerializer.INSTANCE, entryPosition + 1);
            } else {
                value = this.deserializeFromDirectMemory(valueSerializer, entryPosition + 1);
            }
            return new SBTreeEntry<K, Object>(-1L, -1L, key, new OSBTreeValue<Object>(link >= 0L, link, value));
        }
        long leftChild = this.getLongValue(entryPosition);
        long rightChild = this.getLongValue(entryPosition += 8);
        K key = this.deserializeFromDirectMemory(keySerializer, entryPosition += 8);
        return new SBTreeEntry(leftChild, rightChild, key, null);
    }

    public byte[] getRawEntry(int entryIndex, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        int entryPosition;
        int startEntryPosition = entryPosition = this.getIntValue(entryIndex * 4 + 71);
        if (this.isLeaf()) {
            int keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
            assert (this.getByteValue(entryPosition += keySize) == 0);
            int valueSize = this.getObjectSizeInDirectMemory(valueSerializer, entryPosition + 1);
            return this.getBinaryValue(startEntryPosition, keySize + valueSize + 1);
        }
        int keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition += 16);
        return this.getBinaryValue(startEntryPosition, keySize + 16);
    }

    public OSBTreeValue<V> getValue(int entryIndex, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 71);
        boolean isLinkValue = this.getByteValue(entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition)) > 0;
        long link = -1L;
        Object value = null;
        if (isLinkValue) {
            link = this.deserializeFromDirectMemory(OLongSerializer.INSTANCE, entryPosition + 1);
        } else {
            value = this.deserializeFromDirectMemory(valueSerializer, entryPosition + 1);
        }
        return new OSBTreeValue<Object>(link >= 0L, link, value);
    }

    byte[] getRawValue(int entryIndex, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 71);
        entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
        assert (this.getByteValue(entryPosition) == 0);
        int valueSize = this.getObjectSizeInDirectMemory(valueSerializer, entryPosition + 1);
        return this.getBinaryValue(entryPosition + 1, valueSize);
    }

    byte[] getRawKey(int entryIndex, OBinarySerializer<K> keySerializer) {
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 71);
        int keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
        byte[] rawKey = this.getBinaryValue(entryPosition, keySize);
        return rawKey;
    }

    public K getKey(int index, OBinarySerializer<K> keySerializer) {
        int entryPosition = this.getIntValue(index * 4 + 71);
        if (!this.isLeaf()) {
            entryPosition += 16;
        }
        return this.deserializeFromDirectMemory(keySerializer, entryPosition);
    }

    public boolean isLeaf() {
        return this.getByteValue(36) > 0;
    }

    public void addAll(List<byte[]> rawEntries, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        int currentSize = this.size();
        for (int i = 0; i < rawEntries.size(); ++i) {
            this.appendRawEntry(i + currentSize, rawEntries.get(i));
        }
        this.setIntValue(32, rawEntries.size() + currentSize);
        this.addPageOperation(new SBTreeBucketV2AddAllPO(currentSize, rawEntries, keySerializer, valueSerializer));
    }

    public void shrink(int newSize, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        List<byte[]> removedEntries;
        ArrayList<byte[]> rawEntries = new ArrayList<byte[]>(newSize);
        for (int i = 0; i < newSize; ++i) {
            rawEntries.add(this.getRawEntry(i, keySerializer, valueSerializer));
        }
        int oldSize = this.getIntValue(32);
        if (newSize == oldSize) {
            removedEntries = Collections.emptyList();
        } else {
            removedEntries = new ArrayList(oldSize - newSize);
            for (int i = newSize; i < oldSize; ++i) {
                removedEntries.add(this.getRawEntry(i, keySerializer, valueSerializer));
            }
        }
        this.setIntValue(28, OClusterPage.PAGE_SIZE);
        int index = 0;
        for (byte[] entry : rawEntries) {
            this.appendRawEntry(index, entry);
            ++index;
        }
        this.setIntValue(32, newSize);
        this.addPageOperation(new SBTreeBucketV2ShrinkPO(newSize, removedEntries, keySerializer, valueSerializer));
    }

    public boolean addLeafEntry(int index, byte[] serializedKey, byte[] serializedValue) {
        int entrySize = serializedKey.length + serializedValue.length + 1;
        assert (this.isLeaf());
        int size = this.getIntValue(32);
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 71) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(71 + index * 4, 71 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(71 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        this.setBinaryValue(freePointer, serializedKey);
        this.setByteValue(freePointer + serializedKey.length, (byte)0);
        this.setBinaryValue(freePointer + serializedKey.length + 1, serializedValue);
        this.addPageOperation(new SBTreeBucketV2AddLeafEntryPO(index, serializedKey, serializedValue));
        return true;
    }

    private void appendRawEntry(int index, byte[] rawEntry) {
        int freePointer = this.getIntValue(28);
        this.setIntValue(28, freePointer -= rawEntry.length);
        this.setIntValue(71 + index * 4, freePointer);
        this.setBinaryValue(freePointer, rawEntry);
    }

    public boolean addNonLeafEntry(int index, byte[] key, long leftChild, long rightChild, boolean updateNeighbours) {
        assert (!this.isLeaf());
        int entrySize = key.length + 16;
        int size = this.size();
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 71) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(71 + index * 4, 71 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(71 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        freePointer += this.setLongValue(freePointer, leftChild);
        freePointer += this.setLongValue(freePointer, rightChild);
        this.setBinaryValue(freePointer, key);
        int prevChild = -1;
        if (updateNeighbours && ++size > 1) {
            if (index < size - 1) {
                int nextEntryPosition = this.getIntValue(71 + (index + 1) * 4);
                prevChild = (int)this.getLongValue(nextEntryPosition);
                this.setLongValue(nextEntryPosition, rightChild);
            }
            if (index > 0) {
                int prevEntryPosition = this.getIntValue(71 + (index - 1) * 4);
                prevChild = (int)this.getLongValue(prevEntryPosition + 8);
                this.setLongValue(prevEntryPosition + 8, leftChild);
            }
        }
        this.addPageOperation(new SBTreeBucketV2AddNonLeafEntryPO(index, key, updateNeighbours, (int)leftChild, (int)rightChild, prevChild));
        return true;
    }

    public void updateValue(int index, byte[] value, int keySize) {
        int entryPosition = this.getIntValue(index * 4 + 71);
        assert (this.getByteValue(entryPosition += keySize) == 0);
        byte[] prevValue = this.getBinaryValue(++entryPosition, value.length);
        this.setBinaryValue(entryPosition, value);
        this.addPageOperation(new SBTreeBucketV2UpdateValuePO(index, keySize, prevValue, value));
    }

    public void setLeftSibling(long pageIndex) {
        int oldSibling = (int)this.getLongValue(37);
        this.setLongValue(37, pageIndex);
        this.addPageOperation(new SBTreeBucketV2SetLeftSiblingPO(oldSibling, (int)pageIndex));
    }

    public long getLeftSibling() {
        return this.getLongValue(37);
    }

    public void setRightSibling(long pageIndex) {
        int prevSibling = (int)this.getLongValue(45);
        this.setLongValue(45, pageIndex);
        this.addPageOperation(new SBTreeBucketV2SetRightSiblingPO(prevSibling, (int)pageIndex));
    }

    public long getRightSibling() {
        return this.getLongValue(45);
    }

    public static final class SBTreeEntry<K, V>
    implements Comparable<SBTreeEntry<K, V>> {
        private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
        public final long leftChild;
        public final long rightChild;
        public final K key;
        public final OSBTreeValue<V> value;

        public SBTreeEntry(long leftChild, long rightChild, K key, OSBTreeValue<V> value) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SBTreeEntry that = (SBTreeEntry)o;
            if (this.leftChild != that.leftChild) {
                return false;
            }
            if (this.rightChild != that.rightChild) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            if (this.value != null) {
                return this.value.equals(that.value);
            }
            return that.value == null;
        }

        public int hashCode() {
            int result = (int)(this.leftChild ^ this.leftChild >>> 32);
            result = 31 * result + (int)(this.rightChild ^ this.rightChild >>> 32);
            result = 31 * result + this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CellBTreeEntry{leftChild=" + this.leftChild + ", rightChild=" + this.rightChild + ", key=" + this.key + ", value=" + this.value + '}';
        }

        @Override
        public int compareTo(SBTreeEntry<K, V> other) {
            return this.comparator.compare(this.key, other.key);
        }
    }
}

