/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.local.v2;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.nullbucket.SBTreeNullBucketV2InitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.nullbucket.SBTreeNullBucketV2RemoveValuePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.nullbucket.SBTreeNullBucketV2SetValuePO;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v2.OSBTreeValue;

public final class OSBTreeNullBucketV2<V>
extends ODurablePage {
    public OSBTreeNullBucketV2(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init() {
        this.setByteValue(28, (byte)0);
        this.addPageOperation(new SBTreeNullBucketV2InitPO());
    }

    public void setValue(byte[] value, OBinarySerializer<V> valueSerializer) {
        byte[] prevValue = this.getRawValue(valueSerializer);
        this.setByteValue(28, (byte)1);
        this.setByteValue(29, (byte)1);
        this.setBinaryValue(30, value);
        this.addPageOperation(new SBTreeNullBucketV2SetValuePO(prevValue, value, valueSerializer));
    }

    public OSBTreeValue<V> getValue(OBinarySerializer<V> valueSerializer) {
        boolean isLink;
        if (this.getByteValue(28) == 0) {
            return null;
        }
        boolean bl = isLink = this.getByteValue(29) == 0;
        if (isLink) {
            return new OSBTreeValue<Object>(true, this.getLongValue(30), null);
        }
        return new OSBTreeValue<V>(false, -1L, this.deserializeFromDirectMemory(valueSerializer, 30));
    }

    public byte[] getRawValue(OBinarySerializer<V> valueSerializer) {
        boolean isLink;
        if (this.getByteValue(28) == 0) {
            return null;
        }
        boolean bl = isLink = this.getByteValue(29) == 0;
        assert (!isLink);
        return this.getBinaryValue(30, this.getObjectSizeInDirectMemory(valueSerializer, 30));
    }

    public void removeValue(OBinarySerializer<V> valueSerializer) {
        byte[] prevValue = this.getRawValue(valueSerializer);
        this.setByteValue(28, (byte)0);
        this.addPageOperation(new SBTreeNullBucketV2RemoveValuePO(prevValue, valueSerializer));
    }
}

