/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.nullbucket.CellBTreeMultiValueV2NullBucketAddValuePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.nullbucket.CellBTreeMultiValueV2NullBucketDecrementSizePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.nullbucket.CellBTreeMultiValueV2NullBucketIncrementSizePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.nullbucket.CellBTreeMultiValueV2NullBucketInitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.nullbucket.CellBTreeMultiValueV2NullBucketRemoveValuePO;
import java.util.ArrayList;
import java.util.List;

public final class CellBTreeMultiValueV2NullBucket
extends ODurablePage {
    private static final int EMBEDDED_RIDS_BOUNDARY = 64;
    private static final int RID_SIZE = 10;
    private static final int M_ID_OFFSET = 28;
    private static final int EMBEDDED_RIDS_SIZE_OFFSET = 36;
    private static final int RIDS_SIZE_OFFSET = 37;
    private static final int RIDS_OFFSET = 41;

    public CellBTreeMultiValueV2NullBucket(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init(long mId) {
        this.setLongValue(28, mId);
        this.setByteValue(36, (byte)0);
        this.setIntValue(37, 0);
        this.addPageOperation(new CellBTreeMultiValueV2NullBucketInitPO(mId));
    }

    public long addValue(ORID rid) {
        byte embeddedSize = this.getByteValue(36);
        if (embeddedSize < 64) {
            int position = embeddedSize * 10 + 41;
            this.setShortValue(position, (short)rid.getClusterId());
            this.setLongValue(position + 2, rid.getClusterPosition());
            this.setByteValue(36, (byte)(embeddedSize + 1));
            int size = this.getIntValue(37);
            this.setIntValue(37, size + 1);
            this.addPageOperation(new CellBTreeMultiValueV2NullBucketAddValuePO(rid));
            return -1L;
        }
        return this.getLongValue(28);
    }

    public void incrementSize() {
        this.setIntValue(37, this.getIntValue(37) + 1);
        this.addPageOperation(new CellBTreeMultiValueV2NullBucketIncrementSizePO());
    }

    public void decrementSize() {
        int size = this.getIntValue(37);
        assert (size >= 1);
        this.setIntValue(37, size - 1);
        this.addPageOperation(new CellBTreeMultiValueV2NullBucketDecrementSizePO());
    }

    public List<ORID> getValues() {
        int size = this.getIntValue(37);
        ArrayList<ORID> rids = new ArrayList<ORID>(size);
        byte embeddedSize = this.getByteValue(36);
        int end = embeddedSize * 10 + 41;
        for (int position = 41; position < end; position += 10) {
            short clusterId = this.getShortValue(position);
            long clusterPosition = this.getLongValue(position + 2);
            rids.add(new ORecordId(clusterId, clusterPosition));
        }
        return rids;
    }

    public long getMid() {
        return this.getLongValue(28);
    }

    public int getSize() {
        return this.getIntValue(37);
    }

    public int removeValue(ORID rid) {
        int size = this.getIntValue(37);
        byte embeddedSize = this.getByteValue(36);
        int end = embeddedSize * 10 + 41;
        for (int position = 41; position < end; position += 10) {
            long clusterPosition;
            short clusterId = this.getShortValue(position);
            if (clusterId != rid.getClusterId() || (clusterPosition = this.getLongValue(position + 2)) != rid.getClusterPosition()) continue;
            this.moveData(position + 10, position, end - (position + 10));
            this.setByteValue(36, (byte)(embeddedSize - 1));
            this.setIntValue(37, size - 1);
            this.addPageOperation(new CellBTreeMultiValueV2NullBucketRemoveValuePO(new ORecordId(clusterId, clusterPosition)));
            return 1;
        }
        if (embeddedSize <= size) {
            return 0;
        }
        return -1;
    }
}

