/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3AddAllPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3AddLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3AddNonLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3InitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3RemoveLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3RemoveNonLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3SetLeftSiblingPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3SetRightSiblingPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3ShrinkPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3SwitchBucketTypePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket.CellBTreeBucketSingleValueV3UpdateValuePO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public final class CellBTreeSingleValueBucketV3<K>
extends ODurablePage {
    private static final int RID_SIZE = 10;
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int SIZE_OFFSET = 32;
    private static final int IS_LEAF_OFFSET = 36;
    private static final int LEFT_SIBLING_OFFSET = 37;
    private static final int RIGHT_SIBLING_OFFSET = 45;
    private static final int POSITIONS_ARRAY_OFFSET = 53;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;

    public CellBTreeSingleValueBucketV3(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void switchBucketType() {
        if (!this.isEmpty()) {
            throw new IllegalStateException("Type of bucket can be changed only bucket if bucket is empty");
        }
        boolean isLeaf = this.isLeaf();
        if (isLeaf) {
            this.setByteValue(36, (byte)0);
        } else {
            this.setByteValue(36, (byte)1);
        }
        this.addPageOperation(new CellBTreeBucketSingleValueV3SwitchBucketTypePO());
    }

    public void init(boolean isLeaf) {
        this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(32, 0);
        this.setByteValue(36, (byte)(isLeaf ? 1 : 0));
        this.setLongValue(37, -1L);
        this.setLongValue(45, -1L);
        this.addPageOperation(new CellBTreeBucketSingleValueV3InitPO(isLeaf));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int find(K key, OBinarySerializer<K> keySerializer) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = this.getKey(mid, keySerializer);
            int cmp = this.comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void removeLeafEntry(int entryIndex, byte[] key, byte[] value) {
        int entryPosition = this.getIntValue(53 + entryIndex * 4);
        if (!this.isLeaf()) {
            throw new IllegalStateException("Remove is applies to leaf buckets only");
        }
        int entrySize = key.length + 10;
        int size = this.getIntValue(32);
        if (entryIndex < size - 1) {
            this.moveData(53 + (entryIndex + 1) * 4, 53 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(28, freePointer + entrySize);
        int currentPositionOffset = 53;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        this.addPageOperation(new CellBTreeBucketSingleValueV3RemoveLeafEntryPO(entryIndex, key, value));
    }

    public void removeNonLeafEntry(int entryIndex, byte[] key, int prevChild) {
        if (this.isLeaf()) {
            throw new IllegalStateException("Remove is applied to non-leaf buckets only");
        }
        int entryPosition = this.getIntValue(53 + entryIndex * 4);
        int entrySize = key.length + 8;
        int size = this.getIntValue(32);
        int leftChild = this.getIntValue(entryPosition);
        int rightChild = this.getIntValue(entryPosition + 4);
        if (entryIndex < size - 1) {
            this.moveData(53 + (entryIndex + 1) * 4, 53 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(28, freePointer + entrySize);
        int currentPositionOffset = 53;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        if (prevChild >= 0) {
            if (entryIndex > 0) {
                int prevEntryPosition = this.getIntValue(53 + (entryIndex - 1) * 4);
                this.setIntValue(prevEntryPosition + 4, prevChild);
            }
            if (entryIndex < size) {
                int nextEntryPosition = this.getIntValue(53 + entryIndex * 4);
                this.setIntValue(nextEntryPosition, prevChild);
            }
        }
        this.addPageOperation(new CellBTreeBucketSingleValueV3RemoveNonLeafEntryPO(entryIndex, prevChild, key, leftChild, rightChild));
    }

    public int size() {
        return this.getIntValue(32);
    }

    public CellBTreeEntry<K> getEntry(int entryIndex, OBinarySerializer<K> keySerializer) {
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        if (this.isLeaf()) {
            K key = this.deserializeFromDirectMemory(keySerializer, entryPosition);
            entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
            short clusterId = this.getShortValue(entryPosition);
            long clusterPosition = this.getLongValue(entryPosition + 2);
            return new CellBTreeEntry<K>(-1, -1, key, new ORecordId(clusterId, clusterPosition));
        }
        int leftChild = this.getIntValue(entryPosition);
        int rightChild = this.getIntValue(entryPosition += 4);
        K key = this.deserializeFromDirectMemory(keySerializer, entryPosition += 4);
        return new CellBTreeEntry<K>(leftChild, rightChild, key, null);
    }

    public int getLeft(int entryIndex) {
        assert (!this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        return this.getIntValue(entryPosition);
    }

    public int getRight(int entryIndex) {
        assert (!this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        return this.getIntValue(entryPosition + 4);
    }

    public byte[] getRawEntry(int entryIndex, OBinarySerializer<K> keySerializer) {
        int entryPosition;
        int startEntryPosition = entryPosition = this.getIntValue(entryIndex * 4 + 53);
        if (this.isLeaf()) {
            int keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
            return this.getBinaryValue(startEntryPosition, keySize + 10);
        }
        int keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition += 8);
        return this.getBinaryValue(startEntryPosition, keySize + 8);
    }

    public ORID getValue(int entryIndex, OBinarySerializer<K> keySerializer) {
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
        short clusterId = this.getShortValue(entryPosition);
        long clusterPosition = this.getLongValue(entryPosition + 2);
        return new ORecordId(clusterId, clusterPosition);
    }

    byte[] getRawValue(int entryIndex, OBinarySerializer<K> keySerializer) {
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
        return this.getBinaryValue(entryPosition, 10);
    }

    public K getKey(int index, OBinarySerializer<K> keySerializer) {
        int entryPosition = this.getIntValue(index * 4 + 53);
        if (!this.isLeaf()) {
            entryPosition += 8;
        }
        return this.deserializeFromDirectMemory(keySerializer, entryPosition);
    }

    public boolean isLeaf() {
        return this.getByteValue(36) > 0;
    }

    public void addAll(List<byte[]> rawEntries, OBinarySerializer<K> keySerializer) {
        int currentSize = this.size();
        for (int i = 0; i < rawEntries.size(); ++i) {
            this.appendRawEntry(i + currentSize, rawEntries.get(i));
        }
        this.setIntValue(32, rawEntries.size() + currentSize);
        this.addPageOperation(new CellBTreeBucketSingleValueV3AddAllPO(currentSize, rawEntries, keySerializer));
    }

    public void shrink(int newSize, OBinarySerializer<K> keySerializer) {
        int i;
        int currentSize = this.size();
        ArrayList<byte[]> rawEntries = new ArrayList<byte[]>(newSize);
        ArrayList<byte[]> removedEntries = new ArrayList<byte[]>(currentSize - newSize);
        for (i = 0; i < newSize; ++i) {
            rawEntries.add(this.getRawEntry(i, keySerializer));
        }
        for (i = newSize; i < currentSize; ++i) {
            removedEntries.add(this.getRawEntry(i, keySerializer));
        }
        this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
        for (i = 0; i < newSize; ++i) {
            this.appendRawEntry(i, (byte[])rawEntries.get(i));
        }
        this.setIntValue(32, newSize);
        this.addPageOperation(new CellBTreeBucketSingleValueV3ShrinkPO(newSize, removedEntries, keySerializer));
    }

    public boolean addLeafEntry(int index, byte[] serializedKey, byte[] serializedValue) {
        int entrySize = serializedKey.length + serializedValue.length;
        assert (this.isLeaf());
        int size = this.getIntValue(32);
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 53) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(53 + index * 4, 53 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(53 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        this.setBinaryValue(freePointer, serializedKey);
        this.setBinaryValue(freePointer + serializedKey.length, serializedValue);
        this.addPageOperation(new CellBTreeBucketSingleValueV3AddLeafEntryPO(index, serializedKey, serializedValue));
        return true;
    }

    private void appendRawEntry(int index, byte[] rawEntry) {
        int freePointer = this.getIntValue(28);
        this.setIntValue(28, freePointer -= rawEntry.length);
        this.setIntValue(53 + index * 4, freePointer);
        this.setBinaryValue(freePointer, rawEntry);
    }

    public boolean addNonLeafEntry(int index, int leftChild, int rightChild, byte[] key, boolean updateNeighbors) {
        assert (!this.isLeaf());
        int keySize = key.length;
        int entrySize = keySize + 8;
        int size = this.size();
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 53) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(53 + index * 4, 53 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(53 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        freePointer += this.setIntValue(freePointer, leftChild);
        freePointer += this.setIntValue(freePointer, rightChild);
        this.setBinaryValue(freePointer, key);
        int prevChild = -1;
        if (updateNeighbors && ++size > 1) {
            if (index < size - 1) {
                int nextEntryPosition = this.getIntValue(53 + (index + 1) * 4);
                prevChild = this.getIntValue(nextEntryPosition);
                this.setIntValue(nextEntryPosition, rightChild);
            }
            if (index > 0) {
                int prevEntryPosition = this.getIntValue(53 + (index - 1) * 4);
                prevChild = this.getIntValue(prevEntryPosition + 4);
                this.setIntValue(prevEntryPosition + 4, leftChild);
            }
        }
        this.addPageOperation(new CellBTreeBucketSingleValueV3AddNonLeafEntryPO(index, key, updateNeighbors, leftChild, rightChild, prevChild));
        return true;
    }

    public void updateValue(int index, byte[] value, int keySize) {
        int entryPosition = this.getIntValue(index * 4 + 53) + keySize;
        byte[] prevValue = this.getBinaryValue(entryPosition, 10);
        this.setBinaryValue(entryPosition, value);
        this.addPageOperation(new CellBTreeBucketSingleValueV3UpdateValuePO(index, keySize, prevValue, value));
    }

    public void setLeftSibling(long pageIndex) {
        int prevLeft = (int)this.getLongValue(37);
        this.setLongValue(37, pageIndex);
        this.addPageOperation(new CellBTreeBucketSingleValueV3SetLeftSiblingPO(prevLeft, (int)pageIndex));
    }

    public long getLeftSibling() {
        return this.getLongValue(37);
    }

    public void setRightSibling(long pageIndex) {
        int prevRight = (int)this.getLongValue(45);
        this.setLongValue(45, pageIndex);
        this.addPageOperation(new CellBTreeBucketSingleValueV3SetRightSiblingPO(prevRight, (int)pageIndex));
    }

    public long getRightSibling() {
        return this.getLongValue(45);
    }

    public static final class CellBTreeEntry<K>
    implements Comparable<CellBTreeEntry<K>> {
        private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
        protected final int leftChild;
        protected final int rightChild;
        public final K key;
        public final ORID value;

        public CellBTreeEntry(int leftChild, int rightChild, K key, ORID value) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellBTreeEntry that = (CellBTreeEntry)o;
            return this.leftChild == that.leftChild && this.rightChild == that.rightChild && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.leftChild, this.rightChild, this.key, this.value);
        }

        public String toString() {
            return "CellBTreeEntry{leftChild=" + this.leftChild + ", rightChild=" + this.rightChild + ", key=" + this.key + ", value=" + this.value + '}';
        }

        @Override
        public int compareTo(CellBTreeEntry<K> other) {
            return this.comparator.compare(this.key, other.key);
        }
    }
}

