/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.entrypoint.CellBTreeEntryPointSingleValueV3InitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.entrypoint.CellBTreeEntryPointSingleValueV3SetPagesSizePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.entrypoint.CellBTreeEntryPointSingleValueV3SetTreeSizePO;

public final class CellBTreeSingleValueEntryPointV3<K>
extends ODurablePage {
    private static final int KEY_SERIALIZER_OFFSET = 28;
    private static final int KEY_SIZE_OFFSET = 29;
    private static final int TREE_SIZE_OFFSET = 33;
    private static final int PAGES_SIZE_OFFSET = 41;

    public CellBTreeSingleValueEntryPointV3(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init() {
        this.setLongValue(33, 0L);
        this.setIntValue(41, 1);
        this.addPageOperation(new CellBTreeEntryPointSingleValueV3InitPO());
    }

    public void setTreeSize(long size) {
        long prevSize = this.getIntValue(33);
        this.setLongValue(33, size);
        this.addPageOperation(new CellBTreeEntryPointSingleValueV3SetTreeSizePO(prevSize, size));
    }

    public long getTreeSize() {
        return this.getLongValue(33);
    }

    public void setPagesSize(int pages) {
        int prevPagesSize = this.getIntValue(41);
        this.setIntValue(41, pages);
        this.addPageOperation(new CellBTreeEntryPointSingleValueV3SetPagesSizePO(prevPagesSize, pages));
    }

    public int getPagesSize() {
        return this.getIntValue(41);
    }
}

