/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.NotEmptyComponentCanNotBeRemovedException;
import com.orientechnologies.orient.core.exception.OTooBigIndexKeyException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.OCellBTreeSingleValue;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3.CellBTreeSingleValueBucketV3;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3.CellBTreeSingleValueEntryPointV3;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3.CellBTreeSingleValueV3Exception;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3.CellBTreeSingleValueV3NullBucket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CellBTreeSingleValueV3<K>
extends ODurableComponent
implements OCellBTreeSingleValue<K> {
    private static final int SPLITERATOR_CACHE_SIZE = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    private static final int MAX_PATH_LENGTH = OGlobalConfiguration.SBTREE_MAX_DEPTH.getValueAsInteger();
    private static final int ENTRY_POINT_INDEX = 0;
    private static final long ROOT_INDEX = 1L;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final String nullFileExtension;
    private long fileId;
    private long nullBucketFileId = -1L;
    private int keySize;
    private OBinarySerializer<K> keySerializer;
    private OType[] keyTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellBTreeSingleValueV3(String name, String dataFileExtension, String nullFileExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension, name + dataFileExtension);
        this.acquireExclusiveLock();
        try {
            this.nullFileExtension = nullFileExtension;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void create(OAtomicOperation atomicOperation, OBinarySerializer<K> keySerializer, OType[] keyTypes, int keySize, OEncryption encryption) {
        assert (keySerializer != null);
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                this.keySize = keySize;
                this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                this.keySerializer = keySerializer;
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                this.nullBucketFileId = this.addFile(atomicOperation, this.getName() + this.nullFileExtension);
                OCacheEntry entryPointCacheEntry = this.addPage(atomicOperation, this.fileId);
                try {
                    CellBTreeSingleValueEntryPointV3 entryPoint = new CellBTreeSingleValueEntryPointV3(entryPointCacheEntry);
                    entryPoint.init();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
                }
                OCacheEntry rootCacheEntry = this.addPage(atomicOperation, this.fileId);
                try {
                    CellBTreeSingleValueBucketV3 rootBucket = new CellBTreeSingleValueBucketV3(rootCacheEntry);
                    rootBucket.init(true);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, rootCacheEntry);
                }
                OCacheEntry nullCacheEntry = this.addPage(atomicOperation, this.nullBucketFileId);
                try {
                    CellBTreeSingleValueV3NullBucket nullBucket = new CellBTreeSingleValueV3NullBucket(nullCacheEntry);
                    nullBucket.init();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, nullCacheEntry);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ORID get(K key) {
        ORID oRID;
        OCacheEntry keyBucketCacheEntry;
        this.atomicOperationsManager.acquireReadLock(this);
        this.acquireSharedLock();
        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
        if (key != null) {
            BucketSearchResult bucketSearchResult = this.findBucket(key = this.keySerializer.preprocess(key, (Object[])this.keyTypes), atomicOperation);
            if (bucketSearchResult.itemIndex < 0) {
                ORID oRID2 = null;
                return oRID2;
            }
            long pageIndex = bucketSearchResult.pageIndex;
            keyBucketCacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            CellBTreeSingleValueBucketV3<K> keyBucket = new CellBTreeSingleValueBucketV3<K>(keyBucketCacheEntry);
            ORID oRID3 = keyBucket.getValue(bucketSearchResult.itemIndex, this.keySerializer);
            return oRID3;
        }
        OCacheEntry nullBucketCacheEntry = this.loadPageForRead(atomicOperation, this.nullBucketFileId, 0L, false);
        try {
            CellBTreeSingleValueV3NullBucket nullBucket = new CellBTreeSingleValueV3NullBucket(nullBucketCacheEntry);
            oRID = nullBucket.getValue();
        }
        catch (Throwable throwable) {
            try {
                this.releasePageFromRead(atomicOperation, nullBucketCacheEntry);
                throw throwable;
            }
            catch (IOException e) {}
            throw OException.wrapException(new CellBTreeSingleValueV3Exception("Error during retrieving  of sbtree with name " + this.getName(), this), e);
            finally {
                this.releasePageFromRead(atomicOperation, keyBucketCacheEntry);
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
        this.releasePageFromRead(atomicOperation, nullBucketCacheEntry);
        return oRID;
    }

    @Override
    public void put(OAtomicOperation atomicOperation, K key, ORID value) {
        this.update(atomicOperation, key, value, null);
    }

    @Override
    public boolean validatedPut(OAtomicOperation atomicOperation, K key, ORID value, OBaseIndexEngine.Validator<K, ORID> validator) {
        return this.update(atomicOperation, key, value, validator);
    }

    private boolean update(OAtomicOperation atomicOperation, K k, ORID rid, OBaseIndexEngine.Validator<K, ORID> validator) {
        return this.calculateInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                Object key = k;
                ORID value = rid;
                if (key != null) {
                    int sizeDiff;
                    int insertionIndex;
                    ORecordId oldValue;
                    key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                    byte[] serializedKey = this.keySerializer.serializeNativeAsWhole(key, (Object[])this.keyTypes);
                    if (this.keySize > MAX_KEY_SIZE) {
                        throw new OTooBigIndexKeyException("Key size is more than allowed, operation was canceled. Current key size " + this.keySize + ", allowed  " + MAX_KEY_SIZE, this.getName());
                    }
                    UpdateBucketSearchResult bucketSearchResult = this.findBucketForUpdate(key, atomicOperation);
                    OCacheEntry keyBucketCacheEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, true);
                    CellBTreeSingleValueBucketV3<K> keyBucket = new CellBTreeSingleValueBucketV3<K>(keyBucketCacheEntry);
                    byte[] oldRawValue = bucketSearchResult.itemIndex > -1 ? keyBucket.getRawValue(bucketSearchResult.itemIndex, this.keySerializer) : null;
                    if (oldRawValue == null) {
                        oldValue = null;
                    } else {
                        short clusterId = OShortSerializer.INSTANCE.deserializeNative(oldRawValue, 0);
                        long clusterPosition = OLongSerializer.INSTANCE.deserializeNative(oldRawValue, 2);
                        oldValue = new ORecordId(clusterId, clusterPosition);
                    }
                    if (validator != null) {
                        boolean failure = true;
                        boolean ignored = false;
                        try {
                            Object result = validator.validate(key, oldValue, value);
                            if (result == OBaseIndexEngine.Validator.IGNORE) {
                                ignored = true;
                                failure = false;
                                Boolean bl = false;
                                return bl;
                            }
                            value = (ORID)result;
                            failure = false;
                        }
                        finally {
                            if (failure || ignored) {
                                this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                            }
                        }
                    }
                    byte[] serializedValue = new byte[10];
                    OShortSerializer.INSTANCE.serializeNative((short)value.getClusterId(), serializedValue, 0, new Object[0]);
                    OLongSerializer.INSTANCE.serializeNative(value.getClusterPosition(), serializedValue, 2, new Object[0]);
                    if (bucketSearchResult.itemIndex >= 0) {
                        assert (oldRawValue != null);
                        if (oldRawValue.length == serializedValue.length) {
                            keyBucket.updateValue(bucketSearchResult.itemIndex, serializedValue, serializedKey.length);
                            this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                            Boolean bl = true;
                            return bl;
                        }
                        keyBucket.removeLeafEntry(bucketSearchResult.itemIndex, serializedKey, serializedValue);
                        insertionIndex = bucketSearchResult.itemIndex;
                        sizeDiff = 0;
                    } else {
                        insertionIndex = -bucketSearchResult.itemIndex - 1;
                        sizeDiff = 1;
                    }
                    while (!keyBucket.addLeafEntry(insertionIndex, serializedKey, serializedValue)) {
                        bucketSearchResult = this.splitBucket(keyBucket, keyBucketCacheEntry, bucketSearchResult.path, bucketSearchResult.insertionIndexes, insertionIndex, atomicOperation);
                        insertionIndex = bucketSearchResult.itemIndex;
                        long pageIndex = bucketSearchResult.getLastPathItem();
                        if (pageIndex != (long)keyBucketCacheEntry.getPageIndex()) {
                            this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                            keyBucketCacheEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
                        }
                        keyBucket = new CellBTreeSingleValueBucketV3(keyBucketCacheEntry);
                    }
                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                    if (sizeDiff != 0) {
                        this.updateSize(sizeDiff, atomicOperation);
                    }
                } else {
                    OCacheEntry cacheEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                    int sizeDiff = 0;
                    try {
                        Object result;
                        CellBTreeSingleValueV3NullBucket nullBucket = new CellBTreeSingleValueV3NullBucket(cacheEntry);
                        ORID oldValue = nullBucket.getValue();
                        if (validator != null && (result = validator.validate(null, oldValue, value)) == OBaseIndexEngine.Validator.IGNORE) {
                            Boolean bl = false;
                            return bl;
                        }
                        if (oldValue != null) {
                            sizeDiff = -1;
                        }
                        nullBucket.setValue(value);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    this.updateSize(++sizeDiff, atomicOperation);
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.readCache.closeFile(this.fileId, true, this.writeCache);
            this.readCache.closeFile(this.nullBucketFileId, true, this.writeCache);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void delete(OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                long size = this.size();
                if (size > 0L) {
                    throw new NotEmptyComponentCanNotBeRemovedException(this.getName() + " : Not empty index can not be deleted. Index has " + size + " records");
                }
                this.deleteFile(atomicOperation, this.fileId);
                this.deleteFile(atomicOperation, this.nullBucketFileId);
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public void load(String name, int keySize, OType[] keyTypes, OBinarySerializer<K> keySerializer, OEncryption encryption) {
        this.acquireExclusiveLock();
        try {
            OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
            this.fileId = this.openFile(atomicOperation, this.getFullName());
            this.nullBucketFileId = this.openFile(atomicOperation, name + this.nullFileExtension);
            this.keySize = keySize;
            this.keyTypes = keyTypes;
            this.keySerializer = keySerializer;
        }
        catch (IOException e) {
            throw OException.wrapException(new CellBTreeSingleValueV3Exception("Exception during loading of sbtree " + name, this), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ORID remove(OAtomicOperation atomicOperation, K k) {
        return this.calculateInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                ORID removedValue;
                Object key = k;
                if (key != null) {
                    byte[] rawValue;
                    BucketSearchResult bucketSearchResult = this.findBucket(key = this.keySerializer.preprocess(key, (Object[])this.keyTypes), atomicOperation);
                    if (bucketSearchResult.itemIndex < 0) {
                        ORID oRID = null;
                        return oRID;
                    }
                    byte[] serializedKey = this.keySerializer.serializeNativeAsWhole(key, (Object[])this.keyTypes);
                    OCacheEntry keyBucketCacheEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.pageIndex, false, true);
                    try {
                        CellBTreeSingleValueBucketV3<K> keyBucket = new CellBTreeSingleValueBucketV3<K>(keyBucketCacheEntry);
                        rawValue = keyBucket.getRawValue(bucketSearchResult.itemIndex, this.keySerializer);
                        keyBucket.removeLeafEntry(bucketSearchResult.itemIndex, serializedKey, rawValue);
                        this.updateSize(-1L, atomicOperation);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                    }
                    short clusterId = OShortSerializer.INSTANCE.deserializeNative(rawValue, 0);
                    long clusterPosition = OLongSerializer.INSTANCE.deserializeNative(rawValue, 2);
                    removedValue = new ORecordId(clusterId, clusterPosition);
                } else {
                    if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) == 0L) {
                        ORID oRID = null;
                        return oRID;
                    }
                    removedValue = this.removeNullBucket(atomicOperation);
                }
                ORID oRID = removedValue;
                return oRID;
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORID removeNullBucket(OAtomicOperation atomicOperation) throws IOException {
        ORID removedValue;
        OCacheEntry nullCacheEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
        try {
            CellBTreeSingleValueV3NullBucket nullBucket = new CellBTreeSingleValueV3NullBucket(nullCacheEntry);
            removedValue = nullBucket.getValue();
            if (removedValue != null) {
                nullBucket.removeValue();
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, nullCacheEntry);
        }
        if (removedValue != null) {
            this.updateSize(-1L, atomicOperation);
        }
        return removedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<ORawPair<K, ORID>> iterateEntriesMinor(K key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                Stream<ORawPair<K, ORID>> stream;
                this.acquireSharedLock();
                try {
                    if (ascSortOrder) break block8;
                    stream = StreamSupport.stream(this.iterateEntriesMinorDesc(key, inclusive), false);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return stream;
            }
            Stream<ORawPair<K, ORID>> stream = StreamSupport.stream(this.iterateEntriesMinorAsc(key, inclusive), false);
            this.releaseSharedLock();
            return stream;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<ORawPair<K, ORID>> iterateEntriesMajor(K key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                Stream<ORawPair<K, ORID>> stream;
                this.acquireSharedLock();
                try {
                    if (!ascSortOrder) break block8;
                    stream = StreamSupport.stream(this.iterateEntriesMajorAsc(key, inclusive), false);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return stream;
            }
            Stream<ORawPair<K, ORID>> stream = StreamSupport.stream(this.iterateEntriesMajorDesc(key, inclusive), false);
            this.releaseSharedLock();
            return stream;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public K firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public K lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Stream<K> keyStream() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            Stream<Object> stream;
            this.acquireSharedLock();
            try {
                stream = StreamSupport.stream(new SpliteratorForward(null, null, false, false), false).map(entry -> entry.first);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return stream;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public Stream<ORawPair<K, ORID>> allEntries() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            Stream<ORawPair<K, ORID>> stream;
            this.acquireSharedLock();
            try {
                stream = StreamSupport.stream(new SpliteratorForward(null, null, false, false), false);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return stream;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<ORawPair<K, ORID>> iterateEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                Stream<ORawPair<K, ORID>> stream;
                this.acquireSharedLock();
                try {
                    if (!ascSortOrder) break block8;
                    stream = StreamSupport.stream(this.iterateEntriesBetweenAscOrder(keyFrom, fromInclusive, keyTo, toInclusive), false);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return stream;
            }
            Stream<ORawPair<K, ORID>> stream = StreamSupport.stream(this.iterateEntriesBetweenDescOrder(keyFrom, fromInclusive, keyTo, toInclusive), false);
            this.releaseSharedLock();
            return stream;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSize(long diffSize, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry entryPointCacheEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            CellBTreeSingleValueEntryPointV3 entryPoint = new CellBTreeSingleValueEntryPointV3(entryPointCacheEntry);
            entryPoint.setTreeSize(entryPoint.getTreeSize() + diffSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
    }

    private Spliterator<ORawPair<K, ORID>> iterateEntriesMinorDesc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorDesc(key, inclusive);
        return new SpliteratorBackward(null, key, false, inclusive);
    }

    private Spliterator<ORawPair<K, ORID>> iterateEntriesMinorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorAsc(key, inclusive);
        return new SpliteratorForward(null, key, false, inclusive);
    }

    private K enhanceCompositeKeyMinorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMinorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private Spliterator<ORawPair<K, ORID>> iterateEntriesMajorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorAsc(key, inclusive);
        return new SpliteratorForward(key, null, inclusive, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Spliterator<ORawPair<K, ORID>> iterateEntriesMajorDesc(K key, boolean inclusive) {
        this.acquireSharedLock();
        try {
            key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
            key = this.enhanceCompositeKeyMajorDesc(key, inclusive);
            SpliteratorBackward spliteratorBackward = new SpliteratorBackward(key, null, inclusive, false);
            return spliteratorBackward;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private K enhanceCompositeKeyMajorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMajorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<BucketSearchResult> firstItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 1L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        int itemIndex = 0;
        try {
            CellBTreeSingleValueBucketV3 bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
            while (true) {
                Object pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (bucket.isEmpty() || itemIndex > bucket.size()) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = Optional.empty();
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = ((PagePathItemUnit)pagePathItemUnit).pageIndex;
                        itemIndex = ((PagePathItemUnit)pagePathItemUnit).itemIndex + 1;
                    } else {
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        bucketIndex = itemIndex < bucket.size() ? (long)bucket.getLeft(itemIndex) : (long)bucket.getRight(itemIndex - 1);
                        itemIndex = 0;
                    }
                } else {
                    Optional<BucketSearchResult> optional;
                    if (!bucket.isEmpty()) {
                        optional = Optional.of(new BucketSearchResult(0, bucketIndex));
                        return optional;
                    }
                    if (path.isEmpty()) {
                        optional = Optional.empty();
                        return optional;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = ((PagePathItemUnit)pagePathItemUnit).pageIndex;
                    itemIndex = ((PagePathItemUnit)pagePathItemUnit).itemIndex + 1;
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<BucketSearchResult> lastItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 1L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        CellBTreeSingleValueBucketV3 bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
        int itemIndex = bucket.size() - 1;
        try {
            while (true) {
                Object pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (itemIndex < -1) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = Optional.empty();
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = ((PagePathItemUnit)pagePathItemUnit).pageIndex;
                        itemIndex = ((PagePathItemUnit)pagePathItemUnit).itemIndex - 1;
                    } else {
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        bucketIndex = itemIndex > -1 ? (long)bucket.getRight(itemIndex) : (long)bucket.getLeft(0);
                        itemIndex = CellBTreeSingleValueBucketV3.MAX_PAGE_SIZE_BYTES + 1;
                    }
                } else {
                    Optional<BucketSearchResult> optional;
                    if (!bucket.isEmpty()) {
                        optional = Optional.of(new BucketSearchResult(bucket.size() - 1, bucketIndex));
                        return optional;
                    }
                    if (path.isEmpty()) {
                        optional = Optional.empty();
                        return optional;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = ((PagePathItemUnit)pagePathItemUnit).pageIndex;
                    itemIndex = ((PagePathItemUnit)pagePathItemUnit).itemIndex - 1;
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
                if (itemIndex != CellBTreeSingleValueBucketV3.MAX_PAGE_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    private Spliterator<ORawPair<K, ORID>> iterateEntriesBetweenAscOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenAsc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenAsc(keyTo, toInclusive);
        return new SpliteratorForward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private Spliterator<ORawPair<K, ORID>> iterateEntriesBetweenDescOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenDesc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenDesc(keyTo, toInclusive);
        return new SpliteratorBackward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private K enhanceToCompositeKeyBetweenAsc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenAsc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private K enhanceToCompositeKeyBetweenDesc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenDesc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private UpdateBucketSearchResult splitBucket(CellBTreeSingleValueBucketV3<K> bucketToSplit, OCacheEntry entryToSplit, List<Long> path, List<Integer> itemPointers, int keyIndex, OAtomicOperation atomicOperation) throws IOException {
        int startRightIndex;
        boolean splitLeaf = bucketToSplit.isLeaf();
        int bucketSize = bucketToSplit.size();
        int indexToSplit = bucketSize >>> 1;
        K separationKey = bucketToSplit.getKey(indexToSplit, this.keySerializer);
        ArrayList<byte[]> rightEntries = new ArrayList<byte[]>(indexToSplit);
        for (int i = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1; i < bucketSize; ++i) {
            rightEntries.add(bucketToSplit.getRawEntry(i, this.keySerializer));
        }
        if ((long)entryToSplit.getPageIndex() != 1L) {
            return this.splitNonRootBucket(path, itemPointers, keyIndex, entryToSplit.getPageIndex(), bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
        }
        return this.splitRootBucket(keyIndex, entryToSplit, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult splitNonRootBucket(List<Long> path, List<Integer> itemPointers, int keyIndex, long pageIndex, CellBTreeSingleValueBucketV3<K> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<byte[]> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry;
        OCacheEntry entryPointCacheEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            CellBTreeSingleValueEntryPointV3 entryPoint = new CellBTreeSingleValueEntryPointV3(entryPointCacheEntry);
            int pageSize = entryPoint.getPagesSize();
            if ((long)pageSize < this.getFilledUpTo(atomicOperation, this.fileId) - 1L) {
                rightBucketEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, ++pageSize, false, false);
                entryPoint.setPagesSize(pageSize);
            } else {
                assert ((long)pageSize == this.getFilledUpTo(atomicOperation, this.fileId) - 1L);
                rightBucketEntry = this.addPage(atomicOperation, this.fileId);
                entryPoint.setPagesSize(rightBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
        try {
            CellBTreeSingleValueBucketV3<K> newRightBucket = new CellBTreeSingleValueBucketV3<K>(rightBucketEntry);
            newRightBucket.init(splitLeaf);
            newRightBucket.addAll(rightEntries, this.keySerializer);
            bucketToSplit.shrink(indexToSplit, this.keySerializer);
            if (splitLeaf) {
                long rightSiblingPageIndex = bucketToSplit.getRightSibling();
                newRightBucket.setRightSibling(rightSiblingPageIndex);
                newRightBucket.setLeftSibling(pageIndex);
                bucketToSplit.setRightSibling(rightBucketEntry.getPageIndex());
                if (rightSiblingPageIndex >= 0L) {
                    OCacheEntry rightSiblingBucketEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, rightSiblingPageIndex, false, true);
                    CellBTreeSingleValueBucketV3 rightSiblingBucket = new CellBTreeSingleValueBucketV3(rightSiblingBucketEntry);
                    try {
                        rightSiblingBucket.setLeftSibling(rightBucketEntry.getPageIndex());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, rightSiblingBucketEntry);
                    }
                }
            }
            long parentIndex = path.get(path.size() - 2);
            OCacheEntry parentCacheEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
            try {
                CellBTreeSingleValueBucketV3 parentBucket = new CellBTreeSingleValueBucketV3(parentCacheEntry);
                int insertionIndex = itemPointers.get(itemPointers.size() - 2);
                while (!parentBucket.addNonLeafEntry(insertionIndex, (int)pageIndex, rightBucketEntry.getPageIndex(), this.keySerializer.serializeNativeAsWhole(separationKey, (Object[])this.keyTypes), true)) {
                    UpdateBucketSearchResult bucketSearchResult = this.splitBucket(parentBucket, parentCacheEntry, path.subList(0, path.size() - 1), itemPointers.subList(0, itemPointers.size() - 1), insertionIndex, atomicOperation);
                    parentIndex = bucketSearchResult.getLastPathItem();
                    insertionIndex = bucketSearchResult.itemIndex;
                    if (parentIndex != (long)parentCacheEntry.getPageIndex()) {
                        this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                        parentCacheEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
                    }
                    parentBucket = new CellBTreeSingleValueBucketV3(parentCacheEntry);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, parentCacheEntry);
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        ArrayList<Integer> resultItemPointers = new ArrayList<Integer>(itemPointers.subList(0, itemPointers.size() - 1));
        if (keyIndex <= indexToSplit) {
            resultPath.add(pageIndex);
            resultItemPointers.add(keyIndex);
            return new UpdateBucketSearchResult(resultItemPointers, resultPath, keyIndex);
        }
        int parentIndex = resultItemPointers.size() - 1;
        resultItemPointers.set(parentIndex, resultItemPointers.get(parentIndex) + 1);
        resultPath.add(Long.valueOf(rightBucketEntry.getPageIndex()));
        if (splitLeaf) {
            resultItemPointers.add(keyIndex - indexToSplit);
            return new UpdateBucketSearchResult(resultItemPointers, resultPath, keyIndex - indexToSplit);
        }
        resultItemPointers.add(keyIndex - indexToSplit - 1);
        return new UpdateBucketSearchResult(resultItemPointers, resultPath, keyIndex - indexToSplit - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult splitRootBucket(int keyIndex, OCacheEntry bucketEntry, CellBTreeSingleValueBucketV3<K> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<byte[]> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry;
        OCacheEntry leftBucketEntry;
        ArrayList<byte[]> leftEntries = new ArrayList<byte[]>(indexToSplit);
        for (int i = 0; i < indexToSplit; ++i) {
            leftEntries.add(bucketToSplit.getRawEntry(i, this.keySerializer));
        }
        OCacheEntry entryPointCacheEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            CellBTreeSingleValueEntryPointV3 entryPoint = new CellBTreeSingleValueEntryPointV3(entryPointCacheEntry);
            int pageSize = entryPoint.getPagesSize();
            int filledUpTo = (int)this.getFilledUpTo(atomicOperation, this.fileId);
            if (pageSize < filledUpTo - 1) {
                leftBucketEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, ++pageSize, false, false);
            } else {
                assert (pageSize == filledUpTo - 1);
                leftBucketEntry = this.addPage(atomicOperation, this.fileId);
                pageSize = leftBucketEntry.getPageIndex();
            }
            if (pageSize < filledUpTo) {
                rightBucketEntry = CellBTreeSingleValueV3.loadPageForWrite(atomicOperation, this.fileId, ++pageSize, false, false);
            } else {
                assert (pageSize == filledUpTo);
                rightBucketEntry = this.addPage(atomicOperation, this.fileId);
                pageSize = rightBucketEntry.getPageIndex();
            }
            entryPoint.setPagesSize(pageSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
        try {
            CellBTreeSingleValueBucketV3<K> newLeftBucket = new CellBTreeSingleValueBucketV3<K>(leftBucketEntry);
            newLeftBucket.init(splitLeaf);
            newLeftBucket.addAll(leftEntries, this.keySerializer);
            if (splitLeaf) {
                newLeftBucket.setRightSibling(rightBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, leftBucketEntry);
        }
        try {
            CellBTreeSingleValueBucketV3<K> newRightBucket = new CellBTreeSingleValueBucketV3<K>(rightBucketEntry);
            newRightBucket.init(splitLeaf);
            newRightBucket.addAll(rightEntries, this.keySerializer);
            if (splitLeaf) {
                newRightBucket.setLeftSibling(leftBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        bucketToSplit = new CellBTreeSingleValueBucketV3(bucketEntry);
        bucketToSplit.shrink(0, this.keySerializer);
        if (splitLeaf) {
            bucketToSplit.switchBucketType();
        }
        bucketToSplit.addNonLeafEntry(0, leftBucketEntry.getPageIndex(), rightBucketEntry.getPageIndex(), this.keySerializer.serializeNativeAsWhole(separationKey, (Object[])this.keyTypes), true);
        ArrayList<Long> resultPath = new ArrayList<Long>(8);
        resultPath.add(1L);
        ArrayList<Integer> itemPointers = new ArrayList<Integer>(8);
        if (keyIndex <= indexToSplit) {
            itemPointers.add(-1);
            itemPointers.add(keyIndex);
            resultPath.add(Long.valueOf(leftBucketEntry.getPageIndex()));
            return new UpdateBucketSearchResult(itemPointers, resultPath, keyIndex);
        }
        resultPath.add(Long.valueOf(rightBucketEntry.getPageIndex()));
        itemPointers.add(0);
        if (splitLeaf) {
            itemPointers.add(keyIndex - indexToSplit);
            return new UpdateBucketSearchResult(itemPointers, resultPath, keyIndex - indexToSplit);
        }
        itemPointers.add(keyIndex - indexToSplit - 1);
        return new UpdateBucketSearchResult(itemPointers, resultPath, keyIndex - indexToSplit - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 1L;
        int depth = 0;
        while (true) {
            if (++depth > MAX_PATH_LENGTH) {
                throw new CellBTreeSingleValueV3Exception("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                CellBTreeSingleValueBucketV3<K> keyBucket = new CellBTreeSingleValueBucketV3<K>(bucketEntry);
                int index = keyBucket.find(key, this.keySerializer);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, pageIndex);
                    return bucketSearchResult;
                }
                if (index >= 0) {
                    pageIndex = keyBucket.getRight(index);
                    continue;
                }
                int insertionIndex = -index - 1;
                if (insertionIndex >= keyBucket.size()) {
                    pageIndex = keyBucket.getRight(insertionIndex - 1);
                    continue;
                }
                pageIndex = keyBucket.getLeft(insertionIndex);
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult findBucketForUpdate(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 1L;
        ArrayList<Long> path = new ArrayList<Long>(8);
        ArrayList<Integer> itemIndexes = new ArrayList<Integer>(8);
        while (true) {
            if (path.size() > MAX_PATH_LENGTH) {
                throw new CellBTreeSingleValueV3Exception("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            path.add(pageIndex);
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                CellBTreeSingleValueBucketV3<K> keyBucket = new CellBTreeSingleValueBucketV3<K>(bucketEntry);
                int index = keyBucket.find(key, this.keySerializer);
                if (keyBucket.isLeaf()) {
                    itemIndexes.add(index);
                    UpdateBucketSearchResult updateBucketSearchResult = new UpdateBucketSearchResult(itemIndexes, path, index);
                    return updateBucketSearchResult;
                }
                if (index >= 0) {
                    pageIndex = keyBucket.getRight(index);
                    itemIndexes.add(index + 1);
                    continue;
                }
                int insertionIndex = -index - 1;
                pageIndex = insertionIndex >= keyBucket.size() ? (long)keyBucket.getRight(insertionIndex - 1) : (long)keyBucket.getLeft(insertionIndex);
                itemIndexes.add(insertionIndex);
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
                continue;
            }
            break;
        }
    }

    private K enhanceCompositeKey(K key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        if (this.keySize != 1 && compositeKey.getKeys().size() != this.keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = this.keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return (K)fullKey;
        }
        return key;
    }

    private final class SpliteratorBackward
    implements Spliterator<ORawPair<K, ORID>> {
        private final K fromKey;
        private final K toKey;
        private final boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private int pageIndex = -1;
        private int itemIndex = -1;
        private OLogSequenceNumber lastLSN = null;
        private final List<ORawPair<K, ORID>> dataCache = new ArrayList();
        private Iterator<ORawPair<K, ORID>> cacheIterator = Collections.emptyIterator();

        private SpliteratorBackward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
        }

        @Override
        public boolean tryAdvance(Consumer<? super ORawPair<K, ORID>> action) {
            if (this.cacheIterator == null) {
                return false;
            }
            if (this.cacheIterator.hasNext()) {
                action.accept(this.cacheIterator.next());
                return true;
            }
            this.fetchNextCachePortion();
            this.cacheIterator = this.dataCache.iterator();
            if (this.cacheIterator.hasNext()) {
                action.accept(this.cacheIterator.next());
                return true;
            }
            this.cacheIterator = null;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void fetchNextCachePortion() {
            Object lastKey = this.dataCache.isEmpty() ? null : this.dataCache.get((int)(this.dataCache.size() - 1)).first;
            this.dataCache.clear();
            this.cacheIterator = Collections.emptyIterator();
            CellBTreeSingleValueV3.this.atomicOperationsManager.acquireReadLock(CellBTreeSingleValueV3.this);
            try {
                CellBTreeSingleValueV3.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    if (this.pageIndex > -1 && this.readKeysFromBuckets(atomicOperation)) {
                        return;
                    }
                    if (!this.dataCache.isEmpty()) return;
                    if (lastKey == null) {
                        if (this.toKey != null) {
                            BucketSearchResult searchResult = CellBTreeSingleValueV3.this.findBucket(this.toKey, atomicOperation);
                            this.pageIndex = (int)searchResult.pageIndex;
                            this.itemIndex = searchResult.itemIndex >= 0 ? (this.toKeyInclusive ? searchResult.itemIndex : searchResult.itemIndex - 1) : -searchResult.itemIndex - 2;
                        } else {
                            Optional bucketSearchResult = CellBTreeSingleValueV3.this.lastItem(atomicOperation);
                            if (!bucketSearchResult.isPresent()) return;
                            BucketSearchResult searchResult = (BucketSearchResult)bucketSearchResult.get();
                            this.pageIndex = (int)searchResult.pageIndex;
                            this.itemIndex = searchResult.itemIndex;
                        }
                        this.lastLSN = null;
                        this.readKeysFromBuckets(atomicOperation);
                        return;
                    } else {
                        BucketSearchResult bucketSearchResult = CellBTreeSingleValueV3.this.findBucket(lastKey, atomicOperation);
                        this.pageIndex = (int)bucketSearchResult.pageIndex;
                        this.itemIndex = bucketSearchResult.itemIndex >= 0 ? bucketSearchResult.itemIndex - 1 : -bucketSearchResult.itemIndex - 2;
                        this.lastLSN = null;
                        this.readKeysFromBuckets(atomicOperation);
                    }
                    return;
                }
                finally {
                    CellBTreeSingleValueV3.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new CellBTreeSingleValueV3Exception("Error during element iteration", CellBTreeSingleValueV3.this), e);
            }
            finally {
                CellBTreeSingleValueV3.this.atomicOperationsManager.releaseReadLock(CellBTreeSingleValueV3.this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readKeysFromBuckets(OAtomicOperation atomicOperation) throws IOException {
            OCacheEntry cacheEntry = CellBTreeSingleValueV3.this.loadPageForRead(atomicOperation, CellBTreeSingleValueV3.this.fileId, this.pageIndex, false);
            try {
                CellBTreeSingleValueBucketV3 bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
                if (this.lastLSN == null || bucket.getLSN().equals(this.lastLSN)) {
                    do {
                        if (this.itemIndex < 0) {
                            this.pageIndex = (int)bucket.getLeftSibling();
                            if (this.pageIndex < 0) {
                                boolean bl = true;
                                return bl;
                            }
                            CellBTreeSingleValueV3.this.releasePageFromRead(atomicOperation, cacheEntry);
                            cacheEntry = CellBTreeSingleValueV3.this.loadPageForRead(atomicOperation, CellBTreeSingleValueV3.this.fileId, this.pageIndex, false);
                            bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
                            int bucketSize = bucket.size();
                            this.itemIndex = bucketSize - 1;
                        }
                        this.lastLSN = bucket.getLSN();
                        while (this.itemIndex >= 0 && this.dataCache.size() < SPLITERATOR_CACHE_SIZE) {
                            CellBTreeSingleValueBucketV3.CellBTreeEntry entry = bucket.getEntry(this.itemIndex, CellBTreeSingleValueV3.this.keySerializer);
                            if (this.fromKey != null) {
                                if (this.fromKeyInclusive) {
                                    if (CellBTreeSingleValueV3.this.comparator.compare(entry.key, this.fromKey) < 0) {
                                        boolean bl = true;
                                        return bl;
                                    }
                                } else if (CellBTreeSingleValueV3.this.comparator.compare(entry.key, this.fromKey) <= 0) {
                                    boolean bl = true;
                                    return bl;
                                }
                            }
                            this.dataCache.add(new ORawPair(entry.key, entry.value));
                            --this.itemIndex;
                        }
                    } while (this.dataCache.size() < SPLITERATOR_CACHE_SIZE);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                CellBTreeSingleValueV3.this.releasePageFromRead(atomicOperation, cacheEntry);
            }
            return false;
        }

        @Override
        public Spliterator<ORawPair<K, ORID>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 276;
        }

        @Override
        public Comparator<? super ORawPair<K, ORID>> getComparator() {
            return (pairOne, pairTwo) -> -CellBTreeSingleValueV3.this.comparator.compare(pairOne.first, pairTwo.first);
        }
    }

    private final class SpliteratorForward
    implements Spliterator<ORawPair<K, ORID>> {
        private final K fromKey;
        private final K toKey;
        private final boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private int pageIndex = -1;
        private int itemIndex = -1;
        private OLogSequenceNumber lastLSN = null;
        private final List<ORawPair<K, ORID>> dataCache = new ArrayList();
        private Iterator<ORawPair<K, ORID>> cacheIterator = Collections.emptyIterator();

        private SpliteratorForward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.toKeyInclusive = toKeyInclusive;
            this.fromKeyInclusive = fromKeyInclusive;
        }

        @Override
        public boolean tryAdvance(Consumer<? super ORawPair<K, ORID>> action) {
            if (this.cacheIterator == null) {
                return false;
            }
            if (this.cacheIterator.hasNext()) {
                action.accept(this.cacheIterator.next());
                return true;
            }
            this.fetchNextCachePortion();
            this.cacheIterator = this.dataCache.iterator();
            if (this.cacheIterator.hasNext()) {
                action.accept(this.cacheIterator.next());
                return true;
            }
            this.cacheIterator = null;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void fetchNextCachePortion() {
            Object lastKey = !this.dataCache.isEmpty() ? this.dataCache.get((int)(this.dataCache.size() - 1)).first : null;
            this.dataCache.clear();
            this.cacheIterator = Collections.emptyIterator();
            CellBTreeSingleValueV3.this.atomicOperationsManager.acquireReadLock(CellBTreeSingleValueV3.this);
            try {
                CellBTreeSingleValueV3.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    if (this.pageIndex > -1 && this.readKeysFromBuckets(atomicOperation)) {
                        return;
                    }
                    if (!this.dataCache.isEmpty()) return;
                    if (lastKey == null) {
                        if (this.fromKey != null) {
                            BucketSearchResult searchResult = CellBTreeSingleValueV3.this.findBucket(this.fromKey, atomicOperation);
                            this.pageIndex = (int)searchResult.pageIndex;
                            this.itemIndex = searchResult.itemIndex >= 0 ? (this.fromKeyInclusive ? searchResult.itemIndex : searchResult.itemIndex + 1) : -searchResult.itemIndex - 1;
                        } else {
                            Optional bucketSearchResult = CellBTreeSingleValueV3.this.firstItem(atomicOperation);
                            if (!bucketSearchResult.isPresent()) return;
                            BucketSearchResult searchResult = (BucketSearchResult)bucketSearchResult.get();
                            this.pageIndex = (int)searchResult.pageIndex;
                            this.itemIndex = searchResult.itemIndex;
                        }
                        this.lastLSN = null;
                        this.readKeysFromBuckets(atomicOperation);
                        return;
                    } else {
                        BucketSearchResult bucketSearchResult = CellBTreeSingleValueV3.this.findBucket(lastKey, atomicOperation);
                        this.pageIndex = (int)bucketSearchResult.pageIndex;
                        this.itemIndex = bucketSearchResult.itemIndex >= 0 ? bucketSearchResult.itemIndex + 1 : -bucketSearchResult.itemIndex - 1;
                        this.lastLSN = null;
                        this.readKeysFromBuckets(atomicOperation);
                    }
                    return;
                }
                finally {
                    CellBTreeSingleValueV3.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new CellBTreeSingleValueV3Exception("Error during element iteration", CellBTreeSingleValueV3.this), e);
            }
            finally {
                CellBTreeSingleValueV3.this.atomicOperationsManager.releaseReadLock(CellBTreeSingleValueV3.this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readKeysFromBuckets(OAtomicOperation atomicOperation) throws IOException {
            OCacheEntry cacheEntry = CellBTreeSingleValueV3.this.loadPageForRead(atomicOperation, CellBTreeSingleValueV3.this.fileId, this.pageIndex, false);
            try {
                CellBTreeSingleValueBucketV3 bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
                if (this.lastLSN == null || bucket.getLSN().equals(this.lastLSN)) {
                    while (true) {
                        int bucketSize;
                        if (this.itemIndex >= (bucketSize = bucket.size())) {
                            this.pageIndex = (int)bucket.getRightSibling();
                            if (this.pageIndex < 0) {
                                boolean bl = true;
                                return bl;
                            }
                            this.itemIndex = 0;
                            CellBTreeSingleValueV3.this.releasePageFromRead(atomicOperation, cacheEntry);
                            cacheEntry = CellBTreeSingleValueV3.this.loadPageForRead(atomicOperation, CellBTreeSingleValueV3.this.fileId, this.pageIndex, false);
                            bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
                            bucketSize = bucket.size();
                        }
                        this.lastLSN = bucket.getLSN();
                        while (this.itemIndex < bucketSize && this.dataCache.size() < SPLITERATOR_CACHE_SIZE) {
                            CellBTreeSingleValueBucketV3.CellBTreeEntry entry = bucket.getEntry(this.itemIndex, CellBTreeSingleValueV3.this.keySerializer);
                            if (this.toKey != null) {
                                if (this.toKeyInclusive) {
                                    if (CellBTreeSingleValueV3.this.comparator.compare(entry.key, this.toKey) > 0) {
                                        boolean bl = true;
                                        return bl;
                                    }
                                } else if (CellBTreeSingleValueV3.this.comparator.compare(entry.key, this.toKey) >= 0) {
                                    boolean bl = true;
                                    return bl;
                                }
                            }
                            this.dataCache.add(new ORawPair(entry.key, entry.value));
                            ++this.itemIndex;
                        }
                        if (this.dataCache.size() < SPLITERATOR_CACHE_SIZE) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                CellBTreeSingleValueV3.this.releasePageFromRead(atomicOperation, cacheEntry);
            }
            return false;
        }

        @Override
        public Spliterator<ORawPair<K, ORID>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 276;
        }

        @Override
        public Comparator<? super ORawPair<K, ORID>> getComparator() {
            return (pairOne, pairTwo) -> CellBTreeSingleValueV3.this.comparator.compare(pairOne.first, pairTwo.first);
        }
    }

    private static final class PagePathItemUnit {
        private final long pageIndex;
        private final int itemIndex;

        private PagePathItemUnit(long pageIndex, int itemIndex) {
            this.pageIndex = pageIndex;
            this.itemIndex = itemIndex;
        }
    }

    private static final class UpdateBucketSearchResult {
        private final List<Integer> insertionIndexes;
        private final ArrayList<Long> path;
        private final int itemIndex;

        private UpdateBucketSearchResult(List<Integer> insertionIndexes, ArrayList<Long> path, int itemIndex) {
            this.insertionIndexes = insertionIndexes;
            this.path = path;
            this.itemIndex = itemIndex;
        }

        private long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    private static final class BucketSearchResult {
        private final int itemIndex;
        private final long pageIndex;

        private BucketSearchResult(int itemIndex, long pageIndex) {
            this.itemIndex = itemIndex;
            this.pageIndex = pageIndex;
        }
    }

    private static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

