/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.memory;

import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCacheEntryImpl;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OBackgroundExceptionListener;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.OPageIsBrokenListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ODirectMemoryOnlyDiskCache
extends OAbstractWriteCache
implements OReadCache,
OWriteCache {
    private final Lock metadataLock = new ReentrantLock();
    private final Map<String, Integer> fileNameIdMap = new HashMap<String, Integer>();
    private final Map<Integer, String> fileIdNameMap = new HashMap<Integer, String>();
    private final ConcurrentMap<Integer, MemoryFile> files = new ConcurrentHashMap<Integer, MemoryFile>();
    private int counter;
    private final int pageSize;
    private final int id;

    ODirectMemoryOnlyDiskCache(int pageSize, int id) {
        this.pageSize = pageSize;
        this.id = id;
    }

    @Override
    public final Path getRootDirectory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long addFile(String fileName, OWriteCache writeCache) {
        this.metadataLock.lock();
        try {
            Integer fileId = this.fileNameIdMap.get(fileName);
            if (fileId == null) {
                ++this.counter;
            } else {
                throw new OStorageException(fileName + " already exists.");
            }
            int id = this.counter;
            this.files.put(id, new MemoryFile(this.id, id));
            this.fileNameIdMap.put(fileName, id);
            fileId = id;
            this.fileIdNameMap.put(fileId, fileName);
            long l = ODirectMemoryOnlyDiskCache.composeFileId(this.id, fileId);
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long fileIdByName(String fileName) {
        this.metadataLock.lock();
        try {
            Integer fileId = this.fileNameIdMap.get(fileName);
            if (fileId != null) {
                long l = fileId.intValue();
                return l;
            }
        }
        finally {
            this.metadataLock.unlock();
        }
        return -1L;
    }

    @Override
    public final int internalFileId(long fileId) {
        return ODirectMemoryOnlyDiskCache.extractFileId(fileId);
    }

    @Override
    public final long externalFileId(int fileId) {
        return ODirectMemoryOnlyDiskCache.composeFileId(this.id, fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long bookFileId(String fileName) {
        this.metadataLock.lock();
        try {
            ++this.counter;
            long l = ODirectMemoryOnlyDiskCache.composeFileId(this.id, this.counter);
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public final void addBackgroundExceptionListener(OBackgroundExceptionListener listener) {
    }

    @Override
    public final void removeBackgroundExceptionListener(OBackgroundExceptionListener listener) {
    }

    @Override
    public final void checkCacheOverflow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long addFile(String fileName, long fileId, OWriteCache writeCache) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        this.metadataLock.lock();
        try {
            if (this.files.containsKey(intId)) {
                throw new OStorageException("File with id " + intId + " already exists.");
            }
            if (this.fileNameIdMap.containsKey(fileName)) {
                throw new OStorageException(fileName + " already exists.");
            }
            this.files.put(intId, new MemoryFile(this.id, intId));
            this.fileNameIdMap.put(fileName, intId);
            this.fileIdNameMap.put(intId, fileName);
            long l = ODirectMemoryOnlyDiskCache.composeFileId(this.id, intId);
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public final OCacheEntry loadForWrite(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, boolean verifyChecksums, OLogSequenceNumber startLSN) {
        OCacheEntry cacheEntry = this.doLoad(fileId, pageIndex);
        if (cacheEntry == null) {
            return null;
        }
        cacheEntry.acquireExclusiveLock();
        return cacheEntry;
    }

    @Override
    public final OCacheEntry loadForRead(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, boolean verifyChecksums) {
        OCacheEntry cacheEntry = this.doLoad(fileId, pageIndex);
        if (cacheEntry == null) {
            return null;
        }
        cacheEntry.acquireSharedLock();
        return cacheEntry;
    }

    @Override
    public OCacheEntry silentLoadForRead(long extFileId, int pageIndex, OWriteCache writeCache, boolean verifyChecksums) {
        return this.loadForRead(extFileId, pageIndex, false, writeCache, verifyChecksums);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OCacheEntry doLoad(long fileId, long pageIndex) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        MemoryFile memoryFile = this.getFile(intId);
        OCacheEntry cacheEntry = memoryFile.loadPage(pageIndex);
        if (cacheEntry == null) {
            return null;
        }
        OCacheEntry oCacheEntry = cacheEntry;
        synchronized (oCacheEntry) {
            cacheEntry.incrementUsages();
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final OCacheEntry allocateNewPage(long fileId, OWriteCache writeCache, OLogSequenceNumber startLSN) {
        OCacheEntry cacheEntry;
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        MemoryFile memoryFile = this.getFile(intId);
        OCacheEntry oCacheEntry = cacheEntry = memoryFile.addNewPage();
        synchronized (oCacheEntry) {
            cacheEntry.incrementUsages();
        }
        cacheEntry.acquireExclusiveLock();
        return cacheEntry;
    }

    @Override
    public int allocateNewPage(long fileId) {
        throw new UnsupportedOperationException();
    }

    private MemoryFile getFile(int fileId) {
        MemoryFile memoryFile = (MemoryFile)this.files.get(fileId);
        if (memoryFile == null) {
            throw new OStorageException("File with id " + fileId + " does not exist");
        }
        return memoryFile;
    }

    @Override
    public final void releaseFromWrite(OCacheEntry cacheEntry, OWriteCache writeCache, boolean changed) {
        cacheEntry.clearPageOperations();
        cacheEntry.releaseExclusiveLock();
        ODirectMemoryOnlyDiskCache.doRelease(cacheEntry);
    }

    @Override
    public final void releaseFromRead(OCacheEntry cacheEntry, OWriteCache writeCache) {
        cacheEntry.releaseSharedLock();
        ODirectMemoryOnlyDiskCache.doRelease(cacheEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRelease(OCacheEntry cacheEntry) {
        OCacheEntry oCacheEntry = cacheEntry;
        synchronized (oCacheEntry) {
            cacheEntry.decrementUsages();
            assert (cacheEntry.getUsagesCount() > 0 || cacheEntry.getCachePointer().getBuffer() == null || !cacheEntry.isLockAcquiredByCurrentThread());
        }
    }

    @Override
    public final long getFilledUpTo(long fileId) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        MemoryFile memoryFile = this.getFile(intId);
        return memoryFile.size();
    }

    @Override
    public final void flush(long fileId) {
    }

    @Override
    public final void close(long fileId, boolean flush) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteFile(long fileId) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        this.metadataLock.lock();
        try {
            String fileName = this.fileIdNameMap.remove(intId);
            if (fileName == null) {
                return;
            }
            this.fileNameIdMap.remove(fileName);
            MemoryFile file = (MemoryFile)this.files.remove(intId);
            if (file != null) {
                file.clear();
            }
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void renameFile(long fileId, String newFileName) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        this.metadataLock.lock();
        try {
            String fileName = this.fileIdNameMap.get(intId);
            if (fileName == null) {
                return;
            }
            this.fileNameIdMap.remove(fileName);
            this.fileIdNameMap.put(intId, newFileName);
            this.fileNameIdMap.put(newFileName, intId);
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public final void truncateFile(long fileId) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        MemoryFile file = this.getFile(intId);
        file.clear();
    }

    @Override
    public final void flush() {
    }

    @Override
    public final long[] close() {
        return new long[0];
    }

    @Override
    public final void clear() {
        this.delete();
    }

    @Override
    public final long[] delete() {
        this.metadataLock.lock();
        try {
            for (MemoryFile file : this.files.values()) {
                file.clear();
            }
            this.files.clear();
            this.fileIdNameMap.clear();
            this.fileNameIdMap.clear();
        }
        finally {
            this.metadataLock.unlock();
        }
        return new long[0];
    }

    @Override
    public final void deleteStorage(OWriteCache writeCache) {
        this.delete();
    }

    @Override
    public final void closeStorage(OWriteCache writeCache) {
        this.close();
    }

    @Override
    public void changeMaximumAmountOfMemory(long calculateReadCacheMaxMemory) {
    }

    @Override
    public final OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        return OCommonConst.EMPTY_PAGE_DATA_VERIFICATION_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean exists(String name) {
        this.metadataLock.lock();
        try {
            Integer fileId = this.fileNameIdMap.get(name);
            if (fileId == null) {
                boolean bl = false;
                return bl;
            }
            MemoryFile memoryFile = (MemoryFile)this.files.get(fileId);
            boolean bl = memoryFile != null;
            return bl;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean exists(long fileId) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        this.metadataLock.lock();
        try {
            MemoryFile memoryFile = (MemoryFile)this.files.get(intId);
            boolean bl = memoryFile != null;
            return bl;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public void restoreModeOn() {
    }

    @Override
    public void restoreModeOff() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String fileNameById(long fileId) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        this.metadataLock.lock();
        try {
            String string = this.fileIdNameMap.get(intId);
            return string;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public final String nativeFileNameById(long fileId) {
        return this.fileNameById(fileId);
    }

    @Override
    public final long getUsedMemory() {
        long totalPages = 0L;
        for (MemoryFile file : this.files.values()) {
            totalPages += file.getUsedMemory();
        }
        return totalPages * (long)this.pageSize;
    }

    @Override
    public final boolean checkLowDiskSpace() {
        return true;
    }

    @Override
    public final void addPageIsBrokenListener(OPageIsBrokenListener listener) {
    }

    @Override
    public final void removePageIsBrokenListener(OPageIsBrokenListener listener) {
    }

    @Override
    public final void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
    }

    @Override
    public final void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long loadFile(String fileName) {
        this.metadataLock.lock();
        try {
            Integer fileId = this.fileNameIdMap.get(fileName);
            if (fileId == null) {
                throw new OStorageException("File " + fileName + " does not exist.");
            }
            long l = ODirectMemoryOnlyDiskCache.composeFileId(this.id, fileId);
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public final long addFile(String fileName) {
        return this.addFile(fileName, null);
    }

    @Override
    public final long addFile(String fileName, long fileId) {
        return this.addFile(fileName, fileId, null);
    }

    @Override
    public final void store(long fileId, long pageIndex, OCachePointer dataPointer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void makeFuzzyCheckpoint(long segmentId, byte[] lastMetadata) {
    }

    @Override
    public final void flushTillSegment(long segmentId) {
    }

    @Override
    public final Long getMinimalNotFlushedSegment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void updateDirtyPagesTable(OCachePointer pointer, OLogSequenceNumber startLSN) {
    }

    @Override
    public void create() {
    }

    @Override
    public void open() {
    }

    @Override
    public final OCachePointer load(long fileId, long startPageIndex, OModifiableBoolean cacheHit, boolean verifyChecksums) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getExclusiveWriteCachePagesSize() {
        return 0L;
    }

    @Override
    public final void truncateFile(long fileId, OWriteCache writeCache) {
        this.truncateFile(fileId);
    }

    @Override
    public final int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Long> files() {
        HashMap<String, Long> result = new HashMap<String, Long>(1024);
        this.metadataLock.lock();
        try {
            for (Map.Entry<String, Integer> entry : this.fileNameIdMap.entrySet()) {
                if (entry.getValue() <= 0) continue;
                result.put(entry.getKey(), ODirectMemoryOnlyDiskCache.composeFileId(this.id, entry.getValue()));
            }
        }
        finally {
            this.metadataLock.unlock();
        }
        return result;
    }

    @Override
    public final int pageSize() {
        return this.pageSize;
    }

    @Override
    public final boolean fileIdsAreEqual(long firsId, long secondId) {
        int secondIntId;
        int firstIntId = ODirectMemoryOnlyDiskCache.extractFileId(firsId);
        return firstIntId == (secondIntId = ODirectMemoryOnlyDiskCache.extractFileId(secondId));
    }

    @Override
    public final String restoreFileById(long fileId) {
        return null;
    }

    @Override
    public final void closeFile(long fileId, boolean flush, OWriteCache writeCache) {
        this.close(fileId, flush);
    }

    @Override
    public final void deleteFile(long fileId, OWriteCache writeCache) {
        this.deleteFile(fileId);
    }

    private static final class MemoryFile {
        private final int id;
        private final int storageId;
        private final ReadWriteLock clearLock = new ReentrantReadWriteLock();
        private final ConcurrentSkipListMap<Long, OCacheEntry> content = new ConcurrentSkipListMap();

        private MemoryFile(int storageId, int id) {
            this.storageId = storageId;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OCacheEntry loadPage(long index) {
            this.clearLock.readLock().lock();
            try {
                OCacheEntry oCacheEntry = this.content.get(index);
                return oCacheEntry;
            }
            finally {
                this.clearLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OCacheEntry addNewPage() {
            this.clearLock.readLock().lock();
            try {
                OCacheEntryImpl cacheEntry;
                long index;
                do {
                    if (this.content.isEmpty()) {
                        index = 0L;
                    } else {
                        long lastIndex = this.content.lastKey();
                        index = lastIndex + 1L;
                    }
                    OByteBufferPool bufferPool = OByteBufferPool.instance(null);
                    OPointer pointer = bufferPool.acquireDirect(true);
                    OCachePointer cachePointer = new OCachePointer(pointer, bufferPool, this.id, (int)index);
                    cachePointer.incrementReferrer();
                    cacheEntry = new OCacheEntryImpl(OAbstractWriteCache.composeFileId(this.storageId, this.id), (int)index, cachePointer, true);
                    OCacheEntry oldCacheEntry = this.content.putIfAbsent(index, cacheEntry);
                    if (oldCacheEntry == null) continue;
                    cachePointer.decrementReferrer();
                    index = -1L;
                } while (index < 0L);
                OCacheEntryImpl oCacheEntryImpl = cacheEntry;
                return oCacheEntryImpl;
            }
            finally {
                this.clearLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long size() {
            this.clearLock.readLock().lock();
            try {
                if (this.content.isEmpty()) {
                    long l = 0L;
                    return l;
                }
                long l = this.content.lastKey() + 1L;
                return l;
            }
            finally {
                this.clearLock.readLock().unlock();
            }
        }

        private long getUsedMemory() {
            return this.content.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() {
            boolean thereAreNotReleased = false;
            this.clearLock.writeLock().lock();
            try {
                Iterator<OCacheEntry> iterator = this.content.values().iterator();
                while (iterator.hasNext()) {
                    OCacheEntry entry;
                    OCacheEntry oCacheEntry = entry = iterator.next();
                    synchronized (oCacheEntry) {
                        thereAreNotReleased |= entry.getUsagesCount() > 0;
                        entry.getCachePointer().decrementReferrer();
                    }
                }
                this.content.clear();
            }
            finally {
                this.clearLock.writeLock().unlock();
            }
            if (thereAreNotReleased) {
                throw new IllegalStateException("Some cache entries were not released. Storage may be in invalid state.");
            }
        }
    }
}

