/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.ridbag;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDelegate;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.OSimpleMultiValueTracker;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;

public class ORemoteTreeRidBag
implements ORidBagDelegate {
    private int size = -1;
    private OSimpleMultiValueTracker<OIdentifiable, OIdentifiable> tracker = new OSimpleMultiValueTracker(this);
    private boolean autoConvertToRecord = true;
    private transient ORecordElement owner;
    private boolean dirty;
    private boolean transactionDirty = false;
    private ORecordId ownerRecord;
    private String fieldName;
    private OBonsaiCollectionPointer collectionPointer;

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    public ORemoteTreeRidBag(OBonsaiCollectionPointer pointer) {
        this.collectionPointer = pointer;
    }

    @Override
    public ORecordElement getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(ORecordElement owner) {
        if (owner != null && this.owner != null && !this.owner.equals(owner)) {
            throw new IllegalStateException("This data structure is owned by document " + owner + " if you want to use it in other document create new rid bag instance and copy content of current one.");
        }
        this.owner = owner;
        if (this.owner != null && this.tracker.getTimeLine() != null) {
            for (OMultiValueChangeEvent<Object, Object> event : this.tracker.getTimeLine().getMultiValueChangeEvents()) {
                switch (event.getChangeType()) {
                    case ADD: {
                        ORecordInternal.track(this.owner, (OIdentifiable)event.getKey());
                    }
                }
            }
        }
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        List<OIdentifiable> set = this.loadElements();
        if (this.isAutoConvertToRecord()) {
            return new RemovableIterator(set.stream().map(x -> x.getRecord()).iterator());
        }
        return new RemovableIterator(set.iterator());
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        List<OIdentifiable> set = this.loadElements();
        return new RemovableIterator(set.iterator());
    }

    private List<OIdentifiable> loadElements() {
        List set;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().get();
        try (OResultSet result = database.query("select list(@this.field(?)) as elements from ?", this.fieldName, this.ownerRecord);){
            set = result.hasNext() ? (List)result.next().getProperty("elements") : Collections.emptyList();
        }
        if (this.tracker.getTimeLine() != null) {
            for (OMultiValueChangeEvent<Object, Object> event : this.tracker.getTimeLine().getMultiValueChangeEvents()) {
                switch (event.getChangeType()) {
                    case ADD: {
                        set.add((OIdentifiable)event.getKey());
                        break;
                    }
                    case REMOVE: {
                        set.remove(event.getKey());
                    }
                }
            }
        }
        return set;
    }

    @Override
    public void convertLinks2Records() {
    }

    @Override
    public boolean convertRecords2Links() {
        return true;
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.autoConvertToRecord = convertToRecord;
    }

    @Override
    public boolean detach() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAll(Collection<OIdentifiable> values) {
        for (OIdentifiable identifiable : values) {
            this.add(identifiable);
        }
    }

    @Override
    public boolean addInternal(OIdentifiable e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(OIdentifiable identifiable) {
        if (identifiable == null) {
            throw new IllegalArgumentException("Impossible to add a null identifiable in a ridbag");
        }
        if (this.size >= 0) {
            ++this.size;
        }
        this.addEvent(identifiable, identifiable);
    }

    @Override
    public void remove(OIdentifiable identifiable) {
        --this.size;
        this.removeEvent(identifiable);
    }

    @Override
    public boolean contains(OIdentifiable identifiable) {
        return this.loadElements().contains(identifiable);
    }

    @Override
    public int size() {
        return this.updateSize();
    }

    @Override
    public String toString() {
        if (this.size >= 0) {
            return "[size=" + this.size + "]";
        }
        return "[...]";
    }

    @Override
    public NavigableMap<OIdentifiable, Change> getChanges() {
        return new ConcurrentSkipListMap<OIdentifiable, Change>();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Class<?> getGenericClass() {
        return OIdentifiable.class;
    }

    @Override
    public Object returnOriginalState(List<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> multiValueChangeEvents) {
        ORemoteTreeRidBag reverted = new ORemoteTreeRidBag(this.collectionPointer);
        for (OIdentifiable identifiable : this) {
            reverted.add(identifiable);
        }
        ListIterator<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.add(event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public int getSerializedSize() {
        int result = 28;
        if (ODatabaseRecordThreadLocal.instance().get().getStorage() instanceof OStorageProxy || ORecordSerializationContext.getContext() == null) {
            result += this.getChangesSerializedSize();
        }
        return result;
    }

    @Override
    public int getSerializedSize(byte[] stream, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int serialize(byte[] stream, int offset, UUID ownerUuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void requestDelete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int deserialize(byte[] stream, int offset) {
        throw new UnsupportedOperationException();
    }

    private int updateSize() {
        this.size = this.loadElements().size();
        return this.size;
    }

    private int getChangesSerializedSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
    }

    private void addEvent(OIdentifiable key, OIdentifiable identifiable) {
        if (this.owner != null) {
            ORecordInternal.track(this.owner, identifiable);
        }
        if (this.tracker.isEnabled()) {
            this.tracker.addNoDirty(key, identifiable);
        } else {
            this.setDirtyNoChanged();
        }
    }

    private void removeEvent(OIdentifiable removed) {
        if (this.owner != null) {
            ORecordInternal.unTrack(this.owner, removed);
        }
        if (this.tracker.isEnabled()) {
            this.tracker.removeNoDirty(removed, removed);
        } else {
            this.setDirtyNoChanged();
        }
    }

    @Override
    public void enableTracking(ORecordElement parent) {
        if (!this.tracker.isEnabled()) {
            this.tracker.enable();
        }
    }

    @Override
    public void disableTracking(ORecordElement document) {
        if (this.tracker.isEnabled()) {
            this.tracker.disable();
            this.dirty = false;
        }
    }

    @Override
    public void transactionClear() {
        this.tracker.transactionClear();
        this.transactionDirty = false;
    }

    @Override
    public boolean isModified() {
        return this.dirty;
    }

    @Override
    public boolean isTransactionModified() {
        return this.transactionDirty;
    }

    @Override
    public OMultiValueChangeTimeLine<Object, Object> getTimeLine() {
        return this.tracker.getTimeLine();
    }

    @Override
    public <RET> RET setDirty() {
        if (this.owner != null) {
            this.owner.setDirty();
        }
        this.dirty = true;
        this.transactionDirty = true;
        return (RET)this;
    }

    @Override
    public void setTransactionModified(boolean transactionDirty) {
        this.transactionDirty = transactionDirty;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.owner != null) {
            this.owner.setDirtyNoChanged();
        }
        this.dirty = true;
        this.transactionDirty = true;
    }

    @Override
    public OSimpleMultiValueTracker<OIdentifiable, OIdentifiable> getTracker() {
        return this.tracker;
    }

    @Override
    public void setTracker(OSimpleMultiValueTracker<OIdentifiable, OIdentifiable> tracker) {
        this.tracker.sourceFrom(tracker);
    }

    @Override
    public OMultiValueChangeTimeLine<OIdentifiable, OIdentifiable> getTransactionTimeLine() {
        return this.tracker.getTransactionTimeLine();
    }

    public void setRecordAndField(ORecordId id, String fieldName) {
        this.ownerRecord = id;
        this.fieldName = fieldName;
    }

    public OBonsaiCollectionPointer getCollectionPointer() {
        return this.collectionPointer;
    }

    private class RemovableIterator
    implements Iterator<OIdentifiable> {
        private Iterator<OIdentifiable> iter;
        private OIdentifiable next;
        private OIdentifiable removeNext;

        public RemovableIterator(Iterator<OIdentifiable> iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.iter.hasNext()) {
                this.next = this.iter.next();
                return true;
            }
            return false;
        }

        @Override
        public OIdentifiable next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            OIdentifiable val = this.next;
            this.removeNext = this.next;
            this.next = null;
            return val;
        }

        @Override
        public void remove() {
            if (this.removeNext == null) {
                throw new IllegalStateException();
            }
            ORemoteTreeRidBag.this.remove(this.removeNext);
            this.removeNext = null;
        }
    }
}

