/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.ridbag.sbtree;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OAccessToSBtreeCollectionManagerIsProhibitedException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsaiLocal;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManagerAbstract;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

public class OSBTreeCollectionManagerShared
extends OSBTreeCollectionManagerAbstract
implements OOrientStartupListener,
OOrientShutdownListener {
    private static final String PROHIBITED_EXCEPTION_MESSAGE = "Access to the manager of RidBags which are based on B-Tree implementation is prohibited. Typically it means that you use database under distributed cluster configuration. Please check that following setting in your server configuration " + OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.getKey() + " is set to " + Integer.MAX_VALUE;
    private final OAbstractPaginatedStorage storage;
    private volatile boolean prohibitAccess = false;

    public OSBTreeCollectionManagerShared(OAbstractPaginatedStorage storage) {
        super(storage);
        this.storage = storage;
    }

    OSBTreeCollectionManagerShared(int evictionThreshold, int cacheMaxSize, OAbstractPaginatedStorage storage) {
        super(storage, evictionThreshold, cacheMaxSize);
        this.storage = storage;
    }

    public void prohibitAccess() {
        this.prohibitAccess = true;
    }

    private void checkAccess() {
        if (this.prohibitAccess) {
            throw new OAccessToSBtreeCollectionManagerIsProhibitedException(PROHIBITED_EXCEPTION_MESSAGE);
        }
    }

    @Override
    public OSBTreeBonsai<OIdentifiable, Integer> createAndLoadTree(OAtomicOperation atomicOperation, int clusterId) throws IOException {
        this.checkAccess();
        return super.createAndLoadTree(atomicOperation, clusterId);
    }

    @Override
    public OSBTreeBonsai<OIdentifiable, Integer> loadSBTree(OBonsaiCollectionPointer collectionPointer) {
        return super.loadSBTree(collectionPointer);
    }

    @Override
    public void delete(OBonsaiCollectionPointer collectionPointer) {
        super.delete(collectionPointer);
    }

    public void createComponent(OAtomicOperation atomicOperation, int clusterId) {
        if (!this.prohibitAccess) {
            OSBTreeBonsaiLocal tree = new OSBTreeBonsaiLocal("collections_" + clusterId, ".sbc", this.storage);
            tree.createComponent(atomicOperation);
        }
    }

    public long createComponent(OAtomicOperation atomicOperation, String fileName) {
        this.checkAccess();
        OSBTreeBonsaiLocal tree = new OSBTreeBonsaiLocal(fileName, ".sbc", this.storage);
        return tree.createComponent(atomicOperation);
    }

    public boolean isComponentPresent(OAtomicOperation atomicOperation, int clusterId) {
        return atomicOperation.isFileExists("collections_" + clusterId + ".sbc");
    }

    protected OSBTreeBonsaiLocal<OIdentifiable, Integer> createEdgeTree(OAtomicOperation atomicOperation, int clusterId) throws IOException {
        OSBTreeBonsaiLocal<OIdentifiable, Integer> tree = new OSBTreeBonsaiLocal<OIdentifiable, Integer>("collections_" + clusterId, ".sbc", this.storage);
        tree.create(atomicOperation, OLinkSerializer.INSTANCE, OIntegerSerializer.INSTANCE);
        return tree;
    }

    public OBonsaiCollectionPointer createTree(OAtomicOperation atomicOperation, String fileName, int pageIndex, int pageOffset) throws IOException {
        this.checkAccess();
        OSBTreeBonsaiLocal<OIdentifiable, Integer> tree = new OSBTreeBonsaiLocal<OIdentifiable, Integer>(fileName, ".sbc", this.storage);
        tree.create(atomicOperation, OLinkSerializer.INSTANCE, OIntegerSerializer.INSTANCE, pageIndex, pageOffset);
        return tree.getCollectionPointer();
    }

    public void deleteComponentByClusterId(OAtomicOperation atomicOperation, int clusterId) {
        if (!this.prohibitAccess) {
            String fileName = "collections_" + clusterId;
            String fullFileName = fileName + ".sbc";
            long fileId = this.storage.getWriteCache().fileIdByName(fullFileName);
            this.clearClusterCache(fileId, fileName);
            OSBTreeBonsaiLocal tree = new OSBTreeBonsaiLocal(fileName, ".sbc", this.storage);
            tree.deleteComponent(atomicOperation);
        }
    }

    public void deleteComponentByFileId(OAtomicOperation atomicOperation, long fileId) {
        this.checkAccess();
        String fullFileName = this.storage.getWriteCache().fileNameById(fileId);
        String fileName = fullFileName.substring(0, fullFileName.length() - ".sbc".length());
        this.clearClusterCache(fileId, fileName);
        OSBTreeBonsaiLocal tree = new OSBTreeBonsaiLocal(fileName, ".sbc", this.storage);
        tree.deleteComponent(atomicOperation);
    }

    @Override
    public OBonsaiCollectionPointer createSBTree(int clusterId, OAtomicOperation atomicOperation, UUID ownerUUID) throws IOException {
        this.checkAccess();
        OBonsaiCollectionPointer pointer = super.createSBTree(clusterId, atomicOperation, ownerUUID);
        if (ownerUUID != null) {
            Map<UUID, OBonsaiCollectionPointer> changedPointers = ODatabaseRecordThreadLocal.instance().get().getCollectionsChanges();
            if (pointer != null && pointer.isValid()) {
                changedPointers.put(ownerUUID, pointer);
            }
        }
        return pointer;
    }

    @Override
    protected OSBTreeBonsai<OIdentifiable, Integer> loadTree(OBonsaiCollectionPointer collectionPointer) {
        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
        String fileName = atomicOperation == null ? this.storage.getWriteCache().fileNameById(collectionPointer.getFileId()) : atomicOperation.fileNameById(collectionPointer.getFileId());
        if (fileName == null) {
            return null;
        }
        OSBTreeBonsaiLocal<OIdentifiable, Integer> tree = new OSBTreeBonsaiLocal<OIdentifiable, Integer>(fileName.substring(0, fileName.length() - ".sbc".length()), ".sbc", this.storage);
        if (tree.load(collectionPointer.getRootPointer())) {
            return tree;
        }
        return null;
    }

    @Override
    public UUID listenForChanges(ORidBag collection) {
        UUID ownerUUID = collection.getTemporaryId();
        if (ownerUUID != null) {
            OBonsaiCollectionPointer pointer = collection.getPointer();
            ODatabaseDocumentInternal session = ODatabaseRecordThreadLocal.instance().get();
            Map<UUID, OBonsaiCollectionPointer> changedPointers = session.getCollectionsChanges();
            if (pointer != null && pointer.isValid()) {
                changedPointers.put(ownerUUID, pointer);
            }
        }
        return null;
    }

    @Override
    public void updateCollectionPointer(UUID uuid, OBonsaiCollectionPointer pointer) {
    }

    @Override
    public void clearPendingCollections() {
    }

    @Override
    public Map<UUID, OBonsaiCollectionPointer> changedIds() {
        return ODatabaseRecordThreadLocal.instance().get().getCollectionsChanges();
    }

    @Override
    public void clearChangedIds() {
        ODatabaseRecordThreadLocal.instance().get().getCollectionsChanges().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryDelete(OAtomicOperation atomicOperation, OBonsaiCollectionPointer collectionPointer, long delay) {
        Object lock;
        OSBTreeCollectionManagerAbstract.CacheKey cacheKey = new OSBTreeCollectionManagerAbstract.CacheKey(this.storage, collectionPointer);
        Object object = lock = this.treesSubsetLock(cacheKey);
        synchronized (object) {
            OSBTreeCollectionManagerAbstract.SBTreeBonsaiContainer container = (OSBTreeCollectionManagerAbstract.SBTreeBonsaiContainer)this.treeCache.getQuietly(cacheKey);
            if (container != null && (container.usagesCounter != 0 || container.lastAccessTime > System.currentTimeMillis() - delay)) {
                return false;
            }
            this.treeCache.remove(cacheKey);
            OSBTreeBonsai<OIdentifiable, Integer> treeBonsai = this.loadTree(collectionPointer);
            if (treeBonsai == null) {
                return true;
            }
            try {
                OIdentifiable first = treeBonsai.firstKey();
                if (first != null) {
                    OIdentifiable last = treeBonsai.lastKey();
                    ArrayList entriesToDelete = new ArrayList(64);
                    treeBonsai.loadEntriesBetween(first, true, last, true, entry -> {
                        int count = (Integer)entry.getValue();
                        OIdentifiable rid = (OIdentifiable)entry.getKey();
                        for (int i = 0; i < count; ++i) {
                            entriesToDelete.add(rid);
                        }
                        return true;
                    });
                    for (OIdentifiable identifiable : entriesToDelete) {
                        treeBonsai.remove(atomicOperation, identifiable);
                    }
                }
                treeBonsai.delete(atomicOperation);
            }
            catch (IOException e) {
                throw OException.wrapException(new ODatabaseException("Error during ridbag deletion"), e);
            }
        }
        return true;
    }
}

