/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializerDelta;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkDistributed;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;

public class OTransactionDataChange {
    private byte type;
    private byte recordType;
    private ORID id;
    private Optional<byte[]> record;
    private int version;
    private boolean contentChanged;

    public OTransactionDataChange(ORecordOperation operation) {
        this.type = operation.type;
        ORecord rec = operation.getRecord();
        this.recordType = ORecordInternal.getRecordType(rec);
        this.id = rec.getIdentity();
        this.version = rec.getVersion();
        switch (operation.type) {
            case 3: {
                this.record = Optional.of(ORecordSerializerNetworkDistributed.INSTANCE.toStream(rec));
                this.contentChanged = ORecordInternal.isContentChanged(rec);
                break;
            }
            case 1: {
                this.record = this.recordType == 100 ? Optional.of(ODocumentSerializerDelta.instance().serializeDelta((ODocument)rec)) : Optional.of(ORecordSerializerNetworkDistributed.INSTANCE.toStream(rec));
                this.contentChanged = ORecordInternal.isContentChanged(rec);
                break;
            }
            case 2: {
                this.record = Optional.empty();
            }
        }
    }

    private OTransactionDataChange() {
    }

    public OTransactionDataChange(byte type, byte recordType, ORID id, Optional<byte[]> record, int version, boolean contentChanged) {
        this.type = type;
        this.recordType = recordType;
        this.id = id;
        this.record = record;
        this.version = version;
        this.contentChanged = contentChanged;
    }

    public void serialize(DataOutput output) throws IOException {
        output.writeByte(this.type);
        output.writeByte(this.recordType);
        output.writeInt(this.id.getClusterId());
        output.writeLong(this.id.getClusterPosition());
        if (this.record.isPresent()) {
            output.writeBoolean(true);
            output.writeInt(this.record.get().length);
            output.write(this.record.get(), 0, this.record.get().length);
        } else {
            output.writeBoolean(false);
        }
        output.writeInt(this.version);
        output.writeBoolean(this.contentChanged);
    }

    public static OTransactionDataChange deserialize(DataInput input) throws IOException {
        OTransactionDataChange change = new OTransactionDataChange();
        change.type = input.readByte();
        change.recordType = input.readByte();
        int cluster = input.readInt();
        long position = input.readLong();
        change.id = new ORecordId(cluster, position);
        boolean isThereRecord = input.readBoolean();
        if (isThereRecord) {
            int size = input.readInt();
            byte[] record = new byte[size];
            input.readFully(record);
            change.record = Optional.of(record);
        } else {
            change.record = Optional.empty();
        }
        change.version = input.readInt();
        change.contentChanged = input.readBoolean();
        return change;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public byte getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public Optional<byte[]> getRecord() {
        return this.record;
    }

    public boolean isContentChanged() {
        return this.contentChanged;
    }

    public ORID getId() {
        return this.id;
    }
}

