/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTxMetadataHolder;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface OTransactionInternal
extends OBasicTransaction {
    public Collection<ORecordOperation> getRecordOperations();

    public Map<String, OTransactionIndexChanges> getIndexOperations();

    public void setStatus(OTransaction.TXSTATUS var1);

    public ODatabaseDocumentInternal getDatabase();

    public void updateIdentityAfterCommit(ORID var1, ORID var2);

    @Deprecated
    public boolean isUsingLog();

    public ORecordOperation getRecordEntry(ORID var1);

    public Set<ORID> getLockedRecords();

    public void setDatabase(ODatabaseDocumentInternal var1);

    default public boolean isSequenceTransaction() {
        for (ORecordOperation txEntry : this.getRecordOperations()) {
            ODocument doc;
            OClass docClass;
            if (txEntry.record == null || !(txEntry.record.getRecord() instanceof ODocument) || (docClass = (doc = (ODocument)txEntry.record.getRecord()).getSchemaClass()) == null || docClass.isSubClassOf("OSequence")) continue;
            return false;
        }
        return true;
    }

    default public Optional<byte[]> getMetadata() {
        return Optional.empty();
    }

    public void setMetadataHolder(Optional<OTxMetadataHolder> var1);

    default public void storageBegun() {
    }

    public void prepareSerializedOperations() throws IOException;

    public Iterator<byte[]> getSerializedOperations();

    default public void fill(Iterator<ORecordOperation> operations) {
        throw new UnsupportedOperationException();
    }

    public void resetAllocatedIds();
}

