/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.io.PrintStream;
import java.util.Iterator;
import org.apache.commons.configuration.tree.ConfigurationNode;

public final class TreeUtils {
    private TreeUtils() {
    }

    public static void printTree(PrintStream stream, ConfigurationNode result) {
        if (stream != null) {
            TreeUtils.printTree(stream, "", result);
        }
    }

    private static void printTree(PrintStream stream, String indent, ConfigurationNode result) {
        StringBuffer buffer = new StringBuffer(indent).append("<").append(result.getName());
        for (ConfigurationNode node : result.getAttributes()) {
            buffer.append(" ").append(node.getName()).append("='").append(node.getValue()).append("'");
        }
        buffer.append(">");
        stream.print(buffer.toString());
        if (result.getValue() != null) {
            stream.print(result.getValue());
        }
        boolean newline = false;
        if (result.getChildrenCount() > 0) {
            stream.print("\n");
            Iterator<ConfigurationNode> iter2 = result.getChildren().iterator();
            while (iter2.hasNext()) {
                TreeUtils.printTree(stream, indent + "  ", iter2.next());
            }
            newline = true;
        }
        if (newline) {
            stream.print(indent);
        }
        stream.println("</" + result.getName() + ">");
    }
}

