/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.url.ApacheURLLister;

public class URLRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener progress = new RepositoryCopyProgressListener(this);
    private Map resourcesCache = new HashMap();
    private ApacheURLLister lister = new ApacheURLLister();

    public Resource getResource(String source) throws IOException {
        Resource res = (Resource)this.resourcesCache.get(source);
        if (res == null) {
            res = new URLResource(new URL(source));
            this.resourcesCache.put(source, res);
        }
        return res;
    }

    public void get(String source, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source), 5);
        try {
            Resource res = this.getResource(source);
            long totalLength = res.getContentLength();
            if (totalLength > 0L) {
                this.progress.setTotalLength(new Long(totalLength));
            }
            FileUtil.copy(new URL(source), destination, (CopyProgressListener)this.progress);
        }
        catch (IOException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this.progress.setTotalLength(null);
        }
    }

    public void put(File source, String destination, boolean overwrite) throws IOException {
        if (!overwrite && this.getResource(destination).exists()) {
            throw new IOException("destination file exists and overwrite == false");
        }
        this.fireTransferInitiated(this.getResource(destination), 6);
        try {
            long totalLength = source.length();
            if (totalLength > 0L) {
                this.progress.setTotalLength(new Long(totalLength));
            }
            FileUtil.copy(source, new URL(destination), (CopyProgressListener)this.progress);
        }
        catch (IOException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this.progress.setTotalLength(null);
        }
    }

    public List list(String parent) throws IOException {
        if (parent.startsWith("http")) {
            List urls = this.lister.listAll(new URL(parent));
            if (urls != null) {
                ArrayList<String> ret = new ArrayList<String>(urls.size());
                ListIterator iter2 = urls.listIterator();
                while (iter2.hasNext()) {
                    URL url = (URL)iter2.next();
                    ret.add(url.toExternalForm());
                }
                return ret;
            }
        } else if (parent.startsWith("file")) {
            String path;
            try {
                URI uri = new URI(parent);
                path = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException("Couldn't list content of '" + parent + "'");
                ioe.initCause(e);
                throw ioe;
            }
            File file = new File(path);
            if (file.exists() && file.isDirectory()) {
                String[] files = file.list();
                ArrayList<String> ret = new ArrayList<String>(files.length);
                URL context = path.endsWith("/") ? new URL(parent) : new URL(parent + "/");
                for (int i = 0; i < files.length; ++i) {
                    ret.add(new URL(context, files[i]).toExternalForm());
                }
                return ret;
            }
            return Collections.EMPTY_LIST;
        }
        return null;
    }
}

