/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.remote;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.remote.DriverRemoteTraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.remote.traversal.AbstractRemoteTraversal;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.EmptyTraverser;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;

public class DriverRemoteTraversal<S, E>
extends AbstractRemoteTraversal<S, E> {
    private final Iterator<Traverser.Admin<E>> traversers;
    private Traverser.Admin<E> lastTraverser = EmptyTraverser.instance();
    private final RemoteTraversalSideEffects sideEffects;

    public DriverRemoteTraversal(ResultSet rs, Client client, boolean attach, Optional<Configuration> conf) {
        if (attach) {
            if (!conf.isPresent()) {
                throw new IllegalStateException("Traverser can't be reattached for testing");
            }
            Graph graph = (Graph)((Supplier)conf.get().getProperty("gremlin.remote.attachment")).get();
            this.traversers = new AttachingTraverserIterator(rs.iterator(), graph);
        } else {
            this.traversers = new TraverserIterator(rs.iterator());
        }
        this.sideEffects = new DriverRemoteTraversalSideEffects(client, rs);
    }

    @Override
    @Deprecated
    public RemoteTraversalSideEffects getSideEffects() {
        return this.sideEffects;
    }

    @Override
    public boolean hasNext() {
        return this.lastTraverser.bulk() > 0L || this.traversers.hasNext();
    }

    @Override
    public E next() {
        if (0L == this.lastTraverser.bulk()) {
            this.lastTraverser = this.traversers.next();
        }
        if (1L == this.lastTraverser.bulk()) {
            Object temp = this.lastTraverser.get();
            this.lastTraverser = EmptyTraverser.instance();
            return (E)temp;
        }
        this.lastTraverser.setBulk(this.lastTraverser.bulk() - 1L);
        return (E)this.lastTraverser.get();
    }

    @Override
    public Traverser.Admin<E> nextTraverser() {
        if (0L == this.lastTraverser.bulk()) {
            return this.traversers.next();
        }
        Traverser.Admin<E> temp = this.lastTraverser;
        this.lastTraverser = EmptyTraverser.instance();
        return temp;
    }

    @Override
    public void close() throws Exception {
        this.sideEffects.close();
    }

    static class AttachingTraverserIterator<E>
    extends TraverserIterator<E> {
        private final Graph graph;

        public AttachingTraverserIterator(Iterator<Result> resultIterator, Graph graph) {
            super(resultIterator);
            this.graph = graph;
        }

        @Override
        public Traverser.Admin<E> next() {
            Object traverser = super.next();
            if (traverser.get() instanceof Attachable && !(traverser.get() instanceof Property)) {
                traverser.set(((Attachable)traverser.get()).attach(Attachable.Method.get(this.graph)));
            }
            return traverser;
        }
    }

    static class TraverserIterator<E>
    implements Iterator<Traverser.Admin<E>> {
        private final Iterator<Result> inner;

        public TraverserIterator(Iterator<Result> resultIterator) {
            this.inner = resultIterator;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public Traverser.Admin<E> next() {
            return (RemoteTraverser)this.inner.next().getObject();
        }
    }
}

