/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import groovy.json.JsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.AbstractMessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONXModuleV2d0;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphSONMessageSerializerV2d0
extends AbstractMessageSerializer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGraphSONMessageSerializerV2d0.class);
    protected ObjectMapper mapper;

    public AbstractGraphSONMessageSerializerV2d0() {
        GraphSONMapper.Builder builder = this.configureBuilder(this.initBuilder(null));
        this.mapper = builder.create().createMapper();
    }

    @Deprecated
    public AbstractGraphSONMessageSerializerV2d0(GraphSONMapper mapper) {
        this.mapper = mapper.createMapper();
    }

    public AbstractGraphSONMessageSerializerV2d0(GraphSONMapper.Builder mapperBuilder) {
        this.mapper = this.configureBuilder(mapperBuilder).create().createMapper();
    }

    abstract byte[] obtainHeader();

    abstract GraphSONMapper.Builder configureBuilder(GraphSONMapper.Builder var1);

    @Override
    public void configure(Map<String, Object> config, Map<String, Graph> graphs) {
        GraphSONMapper.Builder initialBuilder = this.initBuilder(null);
        this.addIoRegistries(config, initialBuilder);
        this.mapper = this.configureBuilder(initialBuilder).create().createMapper();
    }

    @Override
    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            byte[] payload = this.mapper.writeValueAsBytes(responseMessage);
            encodedMessage = allocator.buffer(payload.length);
            encodedMessage.writeBytes(payload);
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn(String.format("Response [%s] could not be serialized by %s.", responseMessage, AbstractGraphSONMessageSerializerV2d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            byte[] header = this.obtainHeader();
            byte[] payload = this.mapper.writeValueAsBytes(requestMessage);
            encodedMessage = allocator.buffer(header.length + payload.length);
            encodedMessage.writeBytes(header);
            encodedMessage.writeBytes(payload);
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn(String.format("Request [%s] could not be serialized by %s.", requestMessage, AbstractGraphSONMessageSerializerV2d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public RequestMessage deserializeRequest(ByteBuf msg) throws SerializationException {
        try {
            byte[] payload = new byte[msg.readableBytes()];
            msg.readBytes(payload);
            return this.mapper.readValue(payload, RequestMessage.class);
        }
        catch (Exception ex) {
            logger.warn(String.format("Request [%s] could not be deserialized by %s.", msg, AbstractGraphSONMessageSerializerV2d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public ResponseMessage deserializeResponse(ByteBuf msg) throws SerializationException {
        try {
            byte[] payload = new byte[msg.readableBytes()];
            msg.readBytes(payload);
            return this.mapper.readValue(payload, ResponseMessage.class);
        }
        catch (Exception ex) {
            logger.warn(String.format("Response [%s] could not be deserialized by %s.", msg, AbstractGraphSONMessageSerializerV2d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    private GraphSONMapper.Builder initBuilder(GraphSONMapper.Builder builder) {
        GraphSONMapper.Builder b = null == builder ? GraphSONMapper.build() : builder;
        return b.addCustomModule(GraphSONXModuleV2d0.build().create(false)).version(GraphSONVersion.V2_0);
    }

    public static final class ResponseMessageDeserializer
    extends AbstractObjectDeserializer<ResponseMessage> {
        protected ResponseMessageDeserializer() {
            super(ResponseMessage.class);
        }

        @Override
        public ResponseMessage createObject(Map<String, Object> data) {
            Map status = (Map)data.get("status");
            Map result = (Map)data.get("result");
            return ResponseMessage.build(UUID.fromString(data.get("requestId").toString())).code(ResponseStatusCode.getFromValue((Integer)status.get("code"))).statusMessage(status.get("message").toString()).statusAttributes((Map)status.get("attributes")).result(result.get("data")).responseMetaData((Map)result.get("meta")).create();
        }
    }

    public static final class ResponseMessageSerializer
    extends StdSerializer<ResponseMessage> {
        public ResponseMessageSerializer() {
            super(ResponseMessage.class);
        }

        @Override
        public void serialize(ResponseMessage responseMessage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            this.ser(responseMessage, jsonGenerator, serializerProvider, null);
        }

        @Override
        public void serializeWithType(ResponseMessage responseMessage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.ser(responseMessage, jsonGenerator, serializerProvider, typeSerializer);
        }

        public void ser(ResponseMessage responseMessage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            GraphSONUtil.writeStartObject(responseMessage, jsonGenerator, typeSerializer);
            jsonGenerator.writeStringField("requestId", responseMessage.getRequestId() != null ? responseMessage.getRequestId().toString() : null);
            jsonGenerator.writeFieldName("status");
            GraphSONUtil.writeStartObject(responseMessage, jsonGenerator, typeSerializer);
            jsonGenerator.writeStringField("message", responseMessage.getStatus().getMessage());
            jsonGenerator.writeNumberField("code", responseMessage.getStatus().getCode().getValue());
            jsonGenerator.writeObjectField("attributes", responseMessage.getStatus().getAttributes());
            GraphSONUtil.writeEndObject(responseMessage, jsonGenerator, typeSerializer);
            jsonGenerator.writeFieldName("result");
            GraphSONUtil.writeStartObject(responseMessage, jsonGenerator, typeSerializer);
            if (null == responseMessage.getResult().getData()) {
                jsonGenerator.writeNullField("data");
            } else {
                jsonGenerator.writeFieldName("data");
                Object result = responseMessage.getResult().getData();
                serializerProvider.findTypedValueSerializer(result.getClass(), true, null).serialize(result, jsonGenerator, serializerProvider);
            }
            jsonGenerator.writeObjectField("meta", responseMessage.getResult().getMeta());
            GraphSONUtil.writeEndObject(responseMessage, jsonGenerator, typeSerializer);
            GraphSONUtil.writeEndObject(responseMessage, jsonGenerator, typeSerializer);
        }
    }

    public static final class RequestMessageDeserializer
    extends AbstractObjectDeserializer<RequestMessage> {
        protected RequestMessageDeserializer() {
            super(RequestMessage.class);
        }

        @Override
        public RequestMessage createObject(Map<String, Object> data) {
            Map args = (Map)data.get("args");
            RequestMessage.Builder builder = RequestMessage.build(data.get("op").toString()).overrideRequestId(UUID.fromString(data.get("requestId").toString()));
            if (data.containsKey("processor")) {
                builder = builder.processor(data.get("processor").toString());
            }
            if (args != null) {
                for (Map.Entry kv : args.entrySet()) {
                    builder = builder.addArg((String)kv.getKey(), kv.getValue());
                }
            }
            return builder.create();
        }
    }

    public static final class RequestMessageSerializer
    extends StdSerializer<RequestMessage> {
        public RequestMessageSerializer() {
            super(RequestMessage.class);
        }

        @Override
        public void serialize(RequestMessage requestMessage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            this.ser(requestMessage, jsonGenerator, serializerProvider, null);
        }

        @Override
        public void serializeWithType(RequestMessage requestMessage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.ser(requestMessage, jsonGenerator, serializerProvider, typeSerializer);
        }

        public void ser(RequestMessage requestMessage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            GraphSONUtil.writeStartObject(requestMessage, jsonGenerator, typeSerializer);
            jsonGenerator.writeStringField("requestId", requestMessage.getRequestId().toString());
            jsonGenerator.writeStringField("op", requestMessage.getOp());
            jsonGenerator.writeStringField("processor", requestMessage.getProcessor());
            jsonGenerator.writeObjectField("args", requestMessage.getArgs());
            GraphSONUtil.writeEndObject(requestMessage, jsonGenerator, typeSerializer);
        }
    }

    public static final class JsonBuilderJacksonSerializer
    extends StdSerializer<JsonBuilder> {
        public JsonBuilderJacksonSerializer() {
            super(JsonBuilder.class);
        }

        @Override
        public void serialize(JsonBuilder json, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeRaw(":");
            jsonGenerator.writeRaw(json.toString());
            jsonGenerator.writeRaw(",");
        }
    }

    public static final class GremlinServerModule
    extends SimpleModule {
        public GremlinServerModule() {
            super("graphson-gremlin-server");
            this.addSerializer(JsonBuilder.class, new JsonBuilderJacksonSerializer());
            this.addSerializer(ResponseMessage.class, new ResponseMessageSerializer());
            this.addSerializer(RequestMessage.class, new RequestMessageSerializer());
            this.addDeserializer(ResponseMessage.class, new ResponseMessageDeserializer());
            this.addDeserializer(RequestMessage.class, new RequestMessageDeserializer());
        }
    }
}

