/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;

public class RequestMessageGryoSerializer
implements SerializerShim<RequestMessage> {
    @Override
    public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, RequestMessage requestMessage) {
        kryo.writeObject(output, requestMessage.getRequestId());
        output.writeString(requestMessage.getProcessor());
        output.writeString(requestMessage.getOp());
        kryo.writeObject(output, requestMessage.getArgs());
    }

    @Override
    public <I extends InputShim> RequestMessage read(KryoShim<I, ?> kryo, I input, Class<RequestMessage> aClass) {
        UUID id = kryo.readObject(input, UUID.class);
        String processor = input.readString();
        String op = input.readString();
        RequestMessage.Builder builder = RequestMessage.build(op).overrideRequestId(id).processor(processor);
        Map args = kryo.readObject(input, HashMap.class);
        args.forEach(builder::addArg);
        return builder.create();
    }
}

