/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.util.ManagedReference;
import org.codehaus.groovy.util.ReferenceBundle;

class ManagedConcurrentValueMap<K, V> {
    private final ConcurrentHashMap<K, ManagedReference<V>> internalMap;
    private ReferenceBundle bundle;

    public ManagedConcurrentValueMap(ReferenceBundle bundle) {
        this.bundle = bundle;
        this.internalMap = new ConcurrentHashMap();
    }

    public void setBundle(ReferenceBundle bundle) {
        this.bundle = bundle;
    }

    public V get(K key) {
        ManagedReference ref = (ManagedReference)this.internalMap.get(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    public void put(final K key, V value) {
        ManagedReference ref = new ManagedReference<V>(this.bundle, value){

            @Override
            public void finalizeReference() {
                super.finalizeReference();
                ManagedConcurrentValueMap.this.internalMap.remove(key, this.get());
            }
        };
        this.internalMap.put(key, ref);
    }

    public void remove(K key) {
        this.internalMap.remove(key);
    }

    public void clear() {
        this.internalMap.clear();
    }
}

