/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.util.OURLConnection;
import com.orientechnologies.orient.core.util.OURLHelper;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.orientdb.OPartitionedReCreatableDatabasePool;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphBaseFactory;

public final class OrientGraphFactory
implements AutoCloseable,
OrientGraphBaseFactory {
    public static final String ADMIN = "admin";
    protected String connectionURI;
    protected String dbName;
    protected final String user;
    protected final String password;
    protected Configuration configuration;
    protected volatile OPartitionedReCreatableDatabasePool pool;
    protected boolean labelAsClassName;
    protected Optional<ODatabaseType> type;
    protected OrientDB factory;
    protected boolean shouldCloseOrientDB = false;

    public OrientGraphFactory(OrientDB orientdb, String dbName, ODatabaseType type, String user, String password) {
        this.factory = orientdb;
        this.dbName = dbName;
        this.user = user;
        this.password = password;
        this.type = Optional.ofNullable(type);
        this.labelAsClassName = true;
    }

    public OrientGraphFactory() {
        this(new OrientDB("embedded:.", OrientDBConfig.defaultConfig()), "memory_" + System.currentTimeMillis(), ODatabaseType.MEMORY, ADMIN, ADMIN);
        this.shouldCloseOrientDB = true;
    }

    public OrientGraphFactory(String url) {
        this(url, ADMIN, ADMIN);
    }

    public OrientGraphFactory(String url, String user, String password) {
        this.user = user;
        this.password = password;
        this.labelAsClassName = true;
        this.initConnectionParameters(url);
        this.factory = new OrientDB(this.connectionURI, OrientDBConfig.defaultConfig());
        this.shouldCloseOrientDB = true;
    }

    public OrientGraphFactory(Configuration config) {
        this(config.getString("orient-url", "memory:test-" + ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE)), config.getString("orient-user", ADMIN), config.getString("orient-pass", ADMIN));
        this.configuration = config;
    }

    public OrientGraph getNoTx(boolean create, boolean open) {
        return this.getGraph(create, open, false);
    }

    @Override
    public OrientGraph getNoTx() {
        return this.getNoTx(true, true);
    }

    public OrientGraph getTx(boolean create, boolean open) {
        return this.getGraph(create, open, true);
    }

    @Override
    public OrientGraph getTx() {
        return this.getTx(true, true);
    }

    protected OrientGraph getGraph(boolean create, boolean open, boolean transactional) {
        Configuration config = this.getConfiguration(create, open, transactional);
        OrientGraph g = this.pool != null ? new OrientGraph(this, this.acquireFromPool(create, open), config, this.user, this.password) : new OrientGraph(this, this.getDatabase(create, true), config, this.user, this.password);
        this.initGraph(g);
        return g;
    }

    protected void initGraph(OrientGraph g) {
        OSchema schema;
        ODatabaseDocument db = g.getRawDatabase();
        boolean txActive = db.getTransaction().isActive();
        if (txActive) {
            db.commit();
        }
        if (!(schema = db.getMetadata().getSchema()).existsClass("V")) {
            schema.createClass("V").setOverSize(2.0f);
        }
        if (!schema.existsClass("E")) {
            schema.createClass("E");
        }
        if (txActive) {
            db.begin();
        }
    }

    protected Configuration getConfiguration(final boolean create, final boolean open, final boolean transactional) {
        if (this.configuration != null) {
            return this.configuration;
        }
        return new BaseConfiguration(){
            {
                this.setProperty("gremlin.graph", OrientGraph.class.getName());
                this.setProperty("orient-url", OrientGraphFactory.this.connectionURI);
                this.setProperty("orient-db-name", OrientGraphFactory.this.dbName);
                this.setProperty("orient-user", OrientGraphFactory.this.user);
                this.setProperty("orient-pass", OrientGraphFactory.this.password);
                this.setProperty("orient-create", create);
                this.setProperty("orient-open", open);
                this.setProperty("orient-transactional", transactional);
                this.setProperty("orient-label-as-classname", OrientGraphFactory.this.labelAsClassName);
            }
        };
    }

    @Override
    public ODatabaseDocument getDatabase(boolean create, boolean open) {
        if (create && this.type.isPresent()) {
            this.factory.createIfNotExists(this.dbName, this.type.get());
        }
        return this.factory.open(this.dbName, this.user, this.password);
    }

    protected ODatabaseDocument acquireFromPool(boolean create, boolean open) {
        ODatabaseDocument databaseDocument;
        if (create && this.type.isPresent()) {
            this.factory.createIfNotExists(this.dbName, this.type.get());
        }
        if ((databaseDocument = this.pool.acquire()).isClosed()) {
            throw new IllegalStateException("Database returned from document is closed");
        }
        return databaseDocument;
    }

    public OrientGraphBaseFactory setLabelAsClassName(boolean is) {
        this.labelAsClassName = is;
        return this;
    }

    public OrientGraphBaseFactory setupPool(int max) {
        this.pool = new OPartitionedReCreatableDatabasePool(this.factory, this.dbName, this.type, this.user, this.password, max);
        return this;
    }

    public OrientGraphFactory setupPool(int maxPartitionSize, int max) {
        this.pool = new OPartitionedReCreatableDatabasePool(this.factory, this.dbName, this.type, this.user, this.password, max);
        return this;
    }

    public OPartitionedReCreatableDatabasePool pool() {
        return this.pool;
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.close();
        }
        this.pool = null;
        if (this.shouldCloseOrientDB) {
            this.factory.close();
        }
    }

    private void initConnectionParameters(String url) {
        OURLConnection conn = OURLHelper.parseNew(url);
        this.dbName = conn.getDbName();
        this.type = conn.getDbType();
        this.connectionURI = conn.getType() + ":" + conn.getPath();
    }

    @Override
    public void drop() {
        if (this.factory.exists(this.dbName)) {
            this.factory.drop(this.dbName);
        }
        this.factory.close();
    }

    @Override
    public boolean isOpen() {
        return this.factory.isOpen();
    }
}

