/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.util.ImmutableMemory;
import org.javatuples.Pair;

public interface Memory {
    default public boolean exists(String key) {
        return this.keys().contains(key);
    }

    public Set<String> keys();

    public <R> R get(String var1) throws IllegalArgumentException;

    public void set(String var1, Object var2) throws IllegalArgumentException, IllegalStateException;

    public void add(String var1, Object var2) throws IllegalArgumentException, IllegalStateException;

    default public Map<String, Object> asMap() {
        Map<String, Object> map = this.keys().stream().map(key -> Pair.with(key, this.get((String)key))).collect(Collectors.toMap(Pair::getValue0, Pair::getValue1));
        return Collections.unmodifiableMap(map);
    }

    public int getIteration();

    public long getRuntime();

    default public boolean isInitialIteration() {
        return this.getIteration() == 0;
    }

    public static class Exceptions {
        private Exceptions() {
        }

        public static IllegalArgumentException memoryKeyCanNotBeEmpty() {
            return new IllegalArgumentException("Graph computer memory key can not be the empty string");
        }

        public static IllegalArgumentException memoryKeyCanNotBeNull() {
            return new IllegalArgumentException("Graph computer memory key can not be null");
        }

        public static IllegalArgumentException memoryValueCanNotBeNull() {
            return new IllegalArgumentException("Graph computer memory value can not be null");
        }

        public static IllegalStateException memoryIsCurrentlyImmutable() {
            return new IllegalStateException("Graph computer memory is currently immutable");
        }

        public static IllegalArgumentException memoryDoesNotExist(String key) {
            return new IllegalArgumentException("The memory does not have a value for provided key: " + key);
        }

        public static IllegalArgumentException memorySetOnlyDuringVertexProgramSetUpAndTerminate(String key) {
            return new IllegalArgumentException("The memory can only be set() during vertex program setup and terminate: " + key);
        }

        public static IllegalArgumentException memoryAddOnlyDuringVertexProgramExecute(String key) {
            return new IllegalArgumentException("The memory can only be add() during vertex program execute: " + key);
        }
    }

    public static interface Admin
    extends Memory {
        default public void incrIteration() {
            this.setIteration(this.getIteration() + 1);
        }

        public void setIteration(int var1);

        public void setRuntime(long var1);

        default public Memory asImmutable() {
            return new ImmutableMemory(this);
        }
    }
}

